/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.osci.ContentSwapFile;
import de.governikus.csl.osci.OSCIAttachment;
import de.governikus.csl.osci.OSCIAttachmentReference;
import de.governikus.csl.osci.OSCIContainer;
import de.governikus.csl.osci.OSCIContent;
import de.governikus.csl.osci.OSCIContentContainer;
import de.governikus.csl.osci.OSCIContentContainerReference;
import de.governikus.csl.osci.OSCIContentData;
import de.governikus.csl.osci.OSCIData;
import de.governikus.csl.osci.OSCIEncryptedData;
import de.governikus.csl.osci.OSCIMessage;
import de.governikus.csl.osci.OSCIPlugin;
import de.governikus.csl.osci.OSCISignature;
import de.governikus.csl.osci.OSCISignedContentPart;
import de.governikus.csl.osci.OSCIUtil;
import de.governikus.csl.osci.ProcessCardTimestamp;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.jcebase.X509CertificateFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.validate.svp.OSCISignatureRole;
import de.governikus.csl.validation.Configuration;
import de.governikus.csl.validation.IncorrectFormatException;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messagetypes.StoredMessage;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Role;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSCIParser
extends AbstractDocumentParser<OSCIContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSCIParser.class);
    private static final String PARSE_ERROR_MSG = "Document cannot be parsed as an OSCI message!";
    private static final String LOG_ERROR_MSG = "Cannot create OSCI parser for source document: {}";
    private TempDataManager tempDataManager;
    private int swapFileThreshold;
    private AlgorithmManager algorithmManager;
    private OSCIPlugin osciPlugin;

    public OSCIParser(OSCIPlugin osciPlugin, TempDataManager tempDataManager, Configuration configuration) {
        this.tempDataManager = tempDataManager;
        this.algorithmManager = configuration.getAlgorithmManager();
        this.swapFileThreshold = configuration.getSwapFileThreshold();
        this.osciPlugin = osciPlugin;
    }

    public boolean isOsci(SignedData sda) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(sda.getSignature().getInputStream(), StandardCharsets.UTF_8));){
            char[] buffer = new char[2048];
            int readBytes = in.read(buffer, 0, buffer.length);
            String s = "";
            if (readBytes > 0) {
                s = new String(buffer, 0, readBytes);
            }
            if (s.indexOf("\"http://www.osci.de/2002/04/osci\"") <= 0) {
                LOGGER.debug("Document '{}' does not contain the OSCI namespace URI!", (Object)sda.getSignature().getName());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OSCIContainer loadDocument(SignedData sda) throws IOException, ValidatePluginException {
        try {
            if (!this.isOsci(sda)) {
                throw new ValidatePluginException((ValidatePlugin)this.osciPlugin, PARSE_ERROR_MSG);
            }
        }
        catch (IOException e) {
            LOGGER.warn(LOG_ERROR_MSG, (Object)sda.getSignature().getName());
            throw e;
        }
        try (InputStream is = sda.getSignature().getInputStream();){
            OSCIMessage osciMessageCoCo;
            StoredMessage storedMessage = StoredMessage.loadMessage((InputStream)is);
            try {
                osciMessageCoCo = new OSCIMessage(storedMessage, this.algorithmManager);
            }
            catch (IllegalArgumentException ia_ex) {
                OSCIContainer osciMessageContainer = new OSCIContainer(null, sda.getSignature().getName());
                osciMessageContainer.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"osci_cannot_parse_process_card"}));
                OSCIContainer oSCIContainer = osciMessageContainer;
                if (is == null) return oSCIContainer;
                if (throwable == null) {
                    is.close();
                    return oSCIContainer;
                }
                try {
                    is.close();
                    return oSCIContainer;
                }
                catch (Throwable throwable) {
                    throwable.addSuppressed(throwable);
                    return oSCIContainer;
                }
            }
            OSCIContainer osciMessageContainer = new OSCIContainer(osciMessageCoCo, sda.getSignature().getName());
            this.parseOSCIMessage(osciMessageContainer, storedMessage);
            if (osciMessageCoCo.getReceptionTimestamp() == null) {
                osciMessageContainer.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"osci_missing_reception_timestamp"}));
            }
            OSCIContainer oSCIContainer = osciMessageContainer;
            return oSCIContainer;
        }
        catch (NoSuchAlgorithmException nsa_ex) {
            OSCIContainer osciMessageContainer = new OSCIContainer(null, sda.getSignature().getName());
            osciMessageContainer.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"osci_unknown_algorithm"}));
            return osciMessageContainer;
        }
        catch (OSCIException osci_ex) {
            String osciErrorCode = osci_ex.getErrorCode();
            if (OSCIExceptionCodes.OSCIErrorCodes.OSCIMsgStructureNotValid.getOSCICode().equals(osciErrorCode)) {
                throw new IncorrectFormatException((ValidatePlugin)this.osciPlugin, PARSE_ERROR_MSG);
            }
            OSCIContainer osciMessageContainer = new OSCIContainer(null, sda.getSignature().getName());
            ArrayList<String> messages = new ArrayList<String>();
            messages.add("osci_error_code");
            messages.add(osciErrorCode);
            osciMessageContainer.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, messages));
            return osciMessageContainer;
        }
        catch (IOException io_ex) {
            LOGGER.warn(LOG_ERROR_MSG, (Object)sda.getSignature().getName());
            throw io_ex;
        }
        catch (Exception e) {
            throw new IncorrectFormatException((ValidatePlugin)this.osciPlugin, PARSE_ERROR_MSG);
        }
    }

    public void parseOSCIMessage(OSCIContainer osciMessageContainer, StoredMessage storedMessage) throws IOException {
        OSCIMessage osciMessage = (OSCIMessage)osciMessageContainer.getOSCIContainerData();
        for (ContentContainer contentContainer : storedMessage.getContentContainer()) {
            OSCIContainer innerContainerDoc = this.parseContentContainer(osciMessage, null, contentContainer);
            osciMessageContainer.addContainer(innerContainerDoc);
            osciMessage.addContent((OSCIContentContainer)innerContainerDoc.getOSCIContainerData());
        }
        for (ContentContainer contentContainer : storedMessage.getEncryptedData()) {
            try {
                OSCIContainer osciEncDoc = this.createOSCIEncryptedDataContainer(null, (EncryptedDataOSCI)contentContainer);
                osciMessage.addContent((OSCIContent)((Object)osciEncDoc.getOSCIContainerData()));
                osciMessageContainer.addContainer(osciEncDoc);
            }
            catch (Exception ex) {
                throw new IOException("cannot create swap file for encrypted data: " + contentContainer.getRefID());
            }
        }
    }

    private OSCIContainer createOSCIEncryptedDataContainer(OSCIContentContainer parentCoCo, EncryptedDataOSCI encData) throws OSCIException, IOException {
        ContentSwapFile swapFile = ContentSwapFile.create(this.tempDataManager, encData, this.swapFileThreshold);
        OSCIEncryptedData osciEncData = new OSCIEncryptedData(parentCoCo, encData.getRefID(), swapFile);
        for (Role role : encData.getReaders()) {
            if (!role.hasCipherCertificate()) continue;
            osciEncData.addReaderCertificate((X509CertificateFacade)new X509CertificateImpl(role.getCipherCertificate()));
        }
        for (Role role : encData.getAttachments()) {
            swapFile = ContentSwapFile.create(this.tempDataManager, (Attachment)role, this.swapFileThreshold);
            OSCIAttachment osciAttachment = new OSCIAttachment(parentCoCo, role.getRefID(), swapFile);
            osciEncData.addContent(osciAttachment);
        }
        return new OSCIContainer(osciEncData);
    }

    private OSCIContainer parseContentContainer(OSCIMessage osciMessage, OSCIContentContainer parentCoCo, ContentContainer coco) throws IOException {
        OSCIContentContainer osciCoCo = new OSCIContentContainer(parentCoCo, coco.getRefID());
        OSCIContainer osciCoCoDoc = new OSCIContainer(osciCoCo);
        ArrayList<OSCISignature> signatureObjectList = new ArrayList<OSCISignature>();
        if (parentCoCo != null) {
            parentCoCo.addContent(osciCoCo);
        }
        block19: for (Content content : coco.getContents()) {
            switch (content.getContentType()) {
                case 1: {
                    ContentSwapFile swapFile;
                    try {
                        swapFile = ContentSwapFile.create(this.tempDataManager, content, this.swapFileThreshold);
                        osciCoCo.addContent(new OSCIContentContainerReference(parentCoCo, content.getRefID(), swapFile));
                    }
                    catch (Exception ex) {
                        throw new IOException("cannot create swap file for content container: " + content.getRefID());
                    }
                    OSCIContainer innnerContainer = this.parseContentContainer(osciMessage, osciCoCo, content.getContentContainer());
                    osciCoCoDoc.addContainer(innnerContainer);
                    continue block19;
                }
                case 2: {
                    ContentSwapFile swapFile;
                    try {
                        swapFile = ContentSwapFile.create(this.tempDataManager, content, this.swapFileThreshold);
                        OSCIContentData osciContentData = new OSCIContentData(parentCoCo, content.getRefID(), swapFile);
                        osciCoCo.addContent(osciContentData);
                        ArrayList<OSCIContentData> includedFilesToValidate = osciCoCoDoc.getIncludedFilesToValidate();
                        if (includedFilesToValidate == null) {
                            includedFilesToValidate = new ArrayList<OSCIContentData>();
                            osciCoCoDoc.setIncludedFilesToValidate(includedFilesToValidate);
                        }
                        includedFilesToValidate.add(osciContentData);
                        continue block19;
                    }
                    catch (Exception ex) {
                        throw new IOException("cannot create swap file for content data: " + content.getRefID());
                    }
                }
                case 0: {
                    ContentSwapFile swapFile;
                    try {
                        swapFile = ContentSwapFile.create(this.tempDataManager, content, this.swapFileThreshold);
                        osciCoCo.addContent(new OSCIAttachmentReference(parentCoCo, content.getRefID(), swapFile));
                    }
                    catch (Exception ex) {
                        throw new IOException("cannot create swap file for attachment reference: " + content.getRefID());
                    }
                    Attachment osciAtt = content.getAttachment();
                    try {
                        swapFile = ContentSwapFile.create(this.tempDataManager, osciAtt, this.swapFileThreshold);
                        OSCIAttachment osciAttachment = new OSCIAttachment(parentCoCo, osciAtt.getRefID(), swapFile);
                        osciCoCo.addContent(osciAttachment);
                        ArrayList<OSCIAttachment> includedFilesToValidate = osciCoCoDoc.getIncludedFilesToValidate();
                        if (includedFilesToValidate == null) {
                            includedFilesToValidate = new ArrayList<OSCIAttachment>();
                            osciCoCoDoc.setIncludedFilesToValidate(includedFilesToValidate);
                        }
                        includedFilesToValidate.add(osciAttachment);
                        continue block19;
                    }
                    catch (Exception ex) {
                        throw new IOException("cannot create swap file for attachment: " + content.getRefID());
                    }
                }
                default: {
                    ArrayList<String> messages = new ArrayList<String>();
                    messages.add("osci_unknown_content_type");
                    messages.add(String.valueOf(content.getContentType()));
                    osciCoCoDoc.addValidationResult(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, messages));
                }
            }
        }
        for (Content content : coco.getEncryptedData()) {
            try {
                OSCIContainer osciEncDoc = this.createOSCIEncryptedDataContainer(parentCoCo, (EncryptedDataOSCI)content);
                osciCoCo.addContent((OSCIContent)((Object)osciEncDoc.getOSCIContainerData()));
                osciCoCoDoc.addContainer(osciEncDoc);
            }
            catch (Exception ex) {
                throw new IOException("cannot create swap file for encrypted data: " + content.getRefID());
            }
        }
        for (Content content : coco.getSignatures()) {
            OSCISignatureRole cslOSCIRole = null;
            if (content.getSigner() instanceof Author) {
                cslOSCIRole = OSCISignatureRole.AUTHOR;
            } else if (content.getSigner() instanceof Originator) {
                cslOSCIRole = OSCISignatureRole.ORIGINATOR;
            }
            OSCISignature cslOSCISignature = new OSCISignature(osciCoCo.getId(), osciCoCo, cslOSCIRole);
            osciCoCo.addSignature(cslOSCISignature);
            try {
                Date date;
                String sigAlgoName = content.signatureAlgorithm;
                SignatureAlgorithm sigAlgo = this.algorithmManager.getSignatureAlgorithmByURI(sigAlgoName);
                cslOSCISignature.setSignatureAlgorithm(sigAlgo);
                ProcessCardTimestamp receptionTime = osciMessage.getReceptionTimestamp();
                if (receptionTime != null && (date = receptionTime.getDate()) != null) {
                    cslOSCISignature.setSigningTime(SVPFactory.createTypedDate((Date)date, (DateType)DateType.SIGNATURE_TIME_MARK));
                }
                X509Certificate sigCert = null;
                try {
                    sigCert = content.getSigner().getSignatureCertificate();
                }
                catch (OSCIRoleException oSCIRoleException) {
                    // empty catch block
                }
                if (sigCert != null) {
                    cslOSCISignature.setSigningCertificate(new X509CertificateImpl(sigCert));
                }
                cslOSCISignature.setSignatureValue(content.signatureValue);
                cslOSCISignature.setSignedContent((Document)new ByteArrayDocument(content.getSignedInfoBytes()));
                ArrayList<OSCISignedContentPart> contentParts = new ArrayList<OSCISignedContentPart>();
                cslOSCISignature.setSignedContentParts(contentParts);
                for (MessagePart sigRef : OSCIUtil.getReferencesAsList((de.osci.osci12.messageparts.OSCISignature)content)) {
                    String digestAlgoName = OSCIUtil.getDigestMethodAlgorithm(sigRef, (de.osci.osci12.messageparts.OSCISignature)content);
                    DigestAlgorithm digestAlgo = this.algorithmManager.getDigestAlgorithmByURL(digestAlgoName);
                    byte[] digestValue = OSCIUtil.getDigestValue(sigRef, (de.osci.osci12.messageparts.OSCISignature)content);
                    OSCIData osciData = (OSCIData)osciCoCo.getContent(sigRef.getRefID());
                    cslOSCISignature.addContent(osciData);
                    osciData.addSignature(cslOSCISignature);
                    OSCISignedContentPart contentPart = new OSCISignedContentPart(osciData, digestValue, digestAlgo);
                    if (osciData instanceof OSCIAttachmentReference) {
                        contentPart.setContentName(null);
                    }
                    contentParts.add(contentPart);
                }
                signatureObjectList.add(cslOSCISignature);
            }
            catch (Exception ex) {
                LogHelper.logException(null, (Logger)LOGGER, (Throwable)ex);
            }
        }
        if (!signatureObjectList.isEmpty()) {
            osciCoCoDoc.setSignatures(signatureObjectList);
        }
        return osciCoCoDoc;
    }
}

