/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.governikus.csl.core.impl.CertificateWrapper;
import de.governikus.csl.osci.OSCIContainerData;
import de.governikus.csl.osci.OSCIContainerDataProcessor;
import de.governikus.csl.osci.OSCIContent;
import de.governikus.csl.osci.OSCIContentContainer;
import de.governikus.csl.osci.OSCIEncryptedData;
import de.governikus.csl.osci.OSCIMessageType;
import de.governikus.csl.osci.OSCIUtil;
import de.governikus.csl.osci.ProcessCardTimestamp;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.Certificate;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messagetypes.StoredMessage;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import java.util.ArrayList;
import java.util.List;

public class OSCIMessage
implements OSCIContainerData {
    private String msgId;
    private String subject;
    private ProcessCardTimestamp tsReception;
    private List<OSCIContentContainer> cocoList = new ArrayList<OSCIContentContainer>();
    private List<OSCIEncryptedData> encDataList = new ArrayList<OSCIEncryptedData>();
    private List<Certificate> otherAuthorsCertList = new ArrayList<Certificate>();
    private List<Certificate> otherReadersCertList = new ArrayList<Certificate>();
    private X509CertificateImpl addresseeCypherCert;
    private X509CertificateImpl originatorCypherCert;
    private X509CertificateImpl originatorSignatureCert;
    private OSCIMessageType messageType;

    public OSCIMessage(StoredMessage storedMessage, AlgorithmManager algorithmManager) {
        Reader[] otherReaders;
        Originator osciOriginator;
        ProcessCardBundle pcBundle = OSCIUtil.getProcessCardBundle((de.osci.osci12.messagetypes.OSCIMessage)storedMessage);
        if (pcBundle == null) {
            throw new IllegalArgumentException("Cannot extract or parse process card from the message!");
        }
        this.msgId = pcBundle.getMessageId();
        this.subject = pcBundle.getSubject();
        this.tsReception = null;
        try {
            if (pcBundle.getCreation() != null) {
                this.tsReception = new ProcessCardTimestamp(pcBundle.getCreation(), algorithmManager);
            }
        }
        catch (IllegalArgumentException ia_ex) {
            this.tsReception = null;
        }
        Addressee osciAddressee = storedMessage.getAddressee();
        if (osciAddressee != null && osciAddressee.hasCipherCertificate()) {
            try {
                this.addresseeCypherCert = new X509CertificateImpl(osciAddressee.getCipherCertificate());
            }
            catch (OSCIRoleException oSCIRoleException) {
                // empty catch block
            }
        }
        if ((osciOriginator = storedMessage.getOriginator()) != null) {
            if (osciOriginator.hasCipherCertificate()) {
                try {
                    this.originatorCypherCert = new X509CertificateImpl(osciOriginator.getCipherCertificate());
                }
                catch (OSCIRoleException oSCIRoleException) {
                    // empty catch block
                }
            }
            if (osciOriginator.hasSignatureCertificate()) {
                try {
                    this.originatorSignatureCert = new X509CertificateImpl(osciOriginator.getSignatureCertificate());
                }
                catch (OSCIRoleException oSCIRoleException) {
                    // empty catch block
                }
            }
        }
        this.messageType = OSCIMessageType.fromId(storedMessage.getMessageType());
        Author[] otherAuthors = storedMessage.getOtherAuthors();
        if (otherAuthors != null) {
            for (Author otherAuthor : otherAuthors) {
                if (!otherAuthor.hasSignatureCertificate()) continue;
                try {
                    this.otherAuthorsCertList.add((Certificate)new CertificateWrapper(otherAuthor.getSignatureCertificate()));
                }
                catch (OSCIRoleException oSCIRoleException) {
                    // empty catch block
                }
            }
        }
        if ((otherReaders = storedMessage.getOtherReaders()) != null) {
            for (Reader otherReader : otherReaders) {
                if (!otherReader.hasCipherCertificate()) continue;
                try {
                    this.otherReadersCertList.add((Certificate)new CertificateWrapper(otherReader.getCipherCertificate()));
                }
                catch (OSCIRoleException oSCIRoleException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getId() {
        return this.msgId;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public void addContent(OSCIContent content) {
        if (content instanceof OSCIContentContainer) {
            this.cocoList.add((OSCIContentContainer)content);
        } else if (content instanceof OSCIEncryptedData) {
            this.encDataList.add((OSCIEncryptedData)content);
        }
    }

    public List<OSCIContent> getContentList() {
        ArrayList<OSCIContent> contentList = new ArrayList<OSCIContent>();
        contentList.addAll(this.cocoList);
        contentList.addAll(this.encDataList);
        return contentList;
    }

    public List<OSCIContentContainer> getContentContainerList() {
        return new ArrayList<OSCIContentContainer>(this.cocoList);
    }

    public List<OSCIEncryptedData> getEncryptedDataList() {
        return new ArrayList<OSCIEncryptedData>(this.encDataList);
    }

    public ProcessCardTimestamp getReceptionTimestamp() {
        return this.tsReception;
    }

    public X509CertificateImpl getAddresseeCypherCertificate() {
        return this.addresseeCypherCert;
    }

    public X509CertificateImpl getOriginatorCypherCertificate() {
        return this.originatorCypherCert;
    }

    public X509CertificateImpl getOriginatorSignatureCertificate() {
        return this.originatorSignatureCert;
    }

    public OSCIMessageType getMessageType() {
        return this.messageType;
    }

    public List<Certificate> getOtherAuthorsSignatureCertificateList() {
        return new ArrayList<Certificate>(this.otherAuthorsCertList);
    }

    public List<Certificate> getOtherReadersCipherCertificateList() {
        return new ArrayList<Certificate>(this.otherReadersCertList);
    }

    @Override
    public <T> T apply(OSCIContainerDataProcessor<T> processor) {
        return processor.process(this);
    }
}

