/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.governikus.csl.osci.AbstractOSCIData;
import de.governikus.csl.osci.ContentSwapFile;
import de.governikus.csl.osci.OSCIAttachment;
import de.governikus.csl.osci.OSCIContainerData;
import de.governikus.csl.osci.OSCIContainerDataProcessor;
import de.governikus.csl.osci.OSCIContent;
import de.governikus.csl.osci.OSCIContentContainer;
import de.governikus.csl.uom.jcebase.X509CertificateFacade;
import java.util.ArrayList;
import java.util.List;

public class OSCIEncryptedData
extends AbstractOSCIData
implements OSCIContainerData {
    private List<OSCIAttachment> attachmentList = new ArrayList<OSCIAttachment>();
    private List<X509CertificateFacade> readerCertificateList = new ArrayList<X509CertificateFacade>();

    public OSCIEncryptedData(OSCIContentContainer parent, String refId, ContentSwapFile swapFile) {
        super(parent, refId, swapFile);
    }

    @Override
    public void addContent(OSCIContent content) {
        if (content instanceof OSCIAttachment) {
            this.attachmentList.add((OSCIAttachment)content);
        }
    }

    public List<OSCIAttachment> getContentList() {
        return new ArrayList<OSCIAttachment>(this.attachmentList);
    }

    public List<OSCIAttachment> getAttachmentList() {
        return new ArrayList<OSCIAttachment>(this.attachmentList);
    }

    void addReaderCertificate(X509CertificateFacade cert) {
        if (!this.readerCertificateList.contains(cert)) {
            this.readerCertificateList.add(cert);
        }
    }

    public List<X509CertificateFacade> getReaderCertificateList() {
        return new ArrayList<X509CertificateFacade>(this.readerCertificateList);
    }

    @Override
    public <T> T apply(OSCIContainerDataProcessor<T> processor) {
        return processor.process(this);
    }
}

