/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.governikus.csl.osci.OSCIContainer;
import de.governikus.csl.osci.OSCIContainerData;
import de.governikus.csl.osci.OSCIContainerDataMapper;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.dataExtractor.DataExtractor;

public class OSCIDataExtractor
implements DataExtractor<OSCIContainer, OSCIDocumentValidationResult> {
    public void extractData(OSCIContainer source, OSCIDocumentValidationResult destination) {
        destination.setObjectName(source.getName());
        OSCIContainerData osciContainerData = source.getOSCIContainerData();
        if (osciContainerData != null) {
            this.mapOSCIContainerData(osciContainerData, destination);
        }
        for (ValidationResult validationResult : source.getValidationResultList()) {
            destination.getAdditonalValidationResult().add(validationResult);
        }
    }

    private void mapOSCIContainerData(OSCIContainerData osciContainerData, OSCIDocumentValidationResult destination) {
        OSCIContainerDataMapper mapper = new OSCIContainerDataMapper();
        de.governikus.csl.validate.svp.OSCIContainerData mapped = osciContainerData.apply(mapper);
        destination.setOSCIContainerData(mapped);
    }
}

