/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.governikus.csl.osci.AbstractOSCIContent;
import de.governikus.csl.osci.OSCIAttachment;
import de.governikus.csl.osci.OSCIAttachmentReference;
import de.governikus.csl.osci.OSCIContainerData;
import de.governikus.csl.osci.OSCIContainerDataProcessor;
import de.governikus.csl.osci.OSCIContent;
import de.governikus.csl.osci.OSCIContentContainerReference;
import de.governikus.csl.osci.OSCIContentData;
import de.governikus.csl.osci.OSCIData;
import de.governikus.csl.osci.OSCIEncryptedData;
import de.governikus.csl.osci.OSCISignature;
import de.governikus.csl.osci.OSCISignedContentPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OSCIContentContainer
extends AbstractOSCIContent
implements OSCIContainerData {
    private Map<String, OSCIContent> contentMap = new HashMap<String, OSCIContent>();
    private List<OSCISignature> signatureList = new ArrayList<OSCISignature>();
    private List<OSCIContentData> contentDataList = new ArrayList<OSCIContentData>();
    private List<OSCIAttachmentReference> attachmentRefList = new ArrayList<OSCIAttachmentReference>();
    private List<OSCIAttachment> attachmentList = new ArrayList<OSCIAttachment>();
    private List<OSCIContentContainerReference> cocoRefList = new ArrayList<OSCIContentContainerReference>();
    private List<OSCIContentContainer> cocoList = new ArrayList<OSCIContentContainer>();
    private List<OSCIEncryptedData> encDataList = new ArrayList<OSCIEncryptedData>();
    private List<OSCIContent> duplicateRefIdContentList = new ArrayList<OSCIContent>();
    private Set<String> refIdSet = new HashSet<String>();

    public OSCIContentContainer(OSCIContentContainer parent, String refId) {
        super(parent, refId);
    }

    @Override
    public void addContent(OSCIContent content) {
        String contentRefId = content instanceof OSCIData ? ((OSCIData)content).getSignatureId() : content.getId();
        OSCIContent lastContent = this.contentMap.get(contentRefId);
        if (lastContent != null) {
            if (lastContent == content) {
                return;
            }
            if (!this.duplicateRefIdContentList.contains(lastContent)) {
                this.duplicateRefIdContentList.add(lastContent);
            }
            this.duplicateRefIdContentList.add(content);
        }
        this.contentMap.put(contentRefId, content);
        if (content instanceof OSCIEncryptedData) {
            this.refIdSet.add(contentRefId);
            this.encDataList.add((OSCIEncryptedData)content);
        } else if (content instanceof OSCIContentContainerReference) {
            this.refIdSet.add(contentRefId);
            this.cocoRefList.add((OSCIContentContainerReference)content);
        } else if (content instanceof OSCIContentContainer) {
            this.cocoList.add((OSCIContentContainer)content);
        } else if (content instanceof OSCIAttachmentReference) {
            this.refIdSet.add(contentRefId);
            this.attachmentRefList.add((OSCIAttachmentReference)content);
        } else if (content instanceof OSCIAttachment) {
            this.refIdSet.add(contentRefId);
            this.attachmentList.add((OSCIAttachment)content);
        } else if (content instanceof OSCIContentData) {
            this.refIdSet.add(contentRefId);
            this.contentDataList.add((OSCIContentData)content);
        }
    }

    public OSCIContent getContent(String sigRefId) {
        return this.contentMap.get(sigRefId);
    }

    public List<OSCIContent> getContentList() {
        return new ArrayList<OSCIContent>(this.contentMap.values());
    }

    public List<OSCIContentData> getContentDataList() {
        return new ArrayList<OSCIContentData>(this.contentDataList);
    }

    public List<OSCIAttachmentReference> getAttachmentReferenceList() {
        return new ArrayList<OSCIAttachmentReference>(this.attachmentRefList);
    }

    public List<OSCIAttachment> getAttachmentList() {
        return new ArrayList<OSCIAttachment>(this.attachmentList);
    }

    public List<OSCIContentContainerReference> getContentContainerReferenceList() {
        return new ArrayList<OSCIContentContainerReference>(this.cocoRefList);
    }

    public List<OSCIContentContainer> getContentContainerList() {
        return new ArrayList<OSCIContentContainer>(this.cocoList);
    }

    public List<OSCIEncryptedData> getEncryptedDataList() {
        return new ArrayList<OSCIEncryptedData>(this.encDataList);
    }

    public void addSignature(OSCISignature signature) {
        this.signatureList.add(signature);
    }

    public List<OSCISignature> getSignatureList() {
        return new ArrayList<OSCISignature>(this.signatureList);
    }

    public boolean isSigned() {
        return this.signatureList.size() > 0;
    }

    public List<OSCIContent> getUnsignedContentList(OSCISignature signature) {
        HashSet<String> unsignedRefIds = new HashSet<String>(this.refIdSet);
        for (OSCISignedContentPart contentPart : signature.getSignedContentParts()) {
            unsignedRefIds.remove(contentPart.getRefId());
        }
        ArrayList<OSCIContent> unsignedContentList = new ArrayList<OSCIContent>();
        for (String refId : unsignedRefIds) {
            unsignedContentList.add(this.contentMap.get(refId));
        }
        return unsignedContentList;
    }

    public List<OSCIContent> getDuplicateRefIdContentList() {
        return new ArrayList<OSCIContent>(this.duplicateRefIdContentList);
    }

    @Override
    public <T> T apply(OSCIContainerDataProcessor<T> processor) {
        return processor.process(this);
    }
}

