/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.governikus.csl.osci.OSCIUtil;
import de.governikus.csl.uom.util.SwapFile;
import de.governikus.csl.uom.util.TempDataManager;
import de.osci.osci12.OSCIException;
import de.osci.osci12.encryption.OSCICipherException;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messageparts.MessagePartsFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

public class ContentSwapFile
extends SwapFile {
    private String refId;

    public ContentSwapFile(TempDataManager manager, int threshold) {
        super(manager.createTempFile("ContentSwapFile", ".data"), threshold);
        manager.add((Closeable)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSwapFile create(TempDataManager manager, Content content, int threshold) throws IOException, OSCIException {
        ContentSwapFile swapFile = new ContentSwapFile(manager, threshold);
        swapFile.setRefId((MessagePart)content);
        if (content.getContentType() == 2) {
            swapFile.create(content.getContentStream());
        } else {
            try {
                content.writeXML((OutputStream)swapFile.getSwapStream(), false);
            }
            finally {
                swapFile.closeSwapStream();
            }
        }
        return swapFile;
    }

    public static ContentSwapFile create(TempDataManager manager, Attachment attachment, int threshold) throws OSCICipherException, IOException {
        ContentSwapFile swapFile = new ContentSwapFile(manager, threshold);
        swapFile.setRefId((MessagePart)attachment);
        swapFile.create(attachment.getStream());
        return swapFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSwapFile create(TempDataManager manager, EncryptedDataOSCI encryptedData, int threshold) throws OSCIException, IOException {
        ContentSwapFile swapFile = new ContentSwapFile(manager, threshold);
        swapFile.setRefId((MessagePart)encryptedData);
        try {
            MessagePartsFactory.writeXML((MessagePart)encryptedData, (OutputStream)swapFile.getSwapStream());
        }
        finally {
            swapFile.closeSwapStream();
        }
        return swapFile;
    }

    public String getRefId() {
        return this.refId;
    }

    protected void setRefId(MessagePart msgPart) {
        this.refId = OSCIUtil.getReferencePrefix(msgPart) + msgPart.getRefID();
    }
}

