/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.governikus.csl.osci.AbstractOSCIContent;
import de.governikus.csl.osci.ContentSwapFile;
import de.governikus.csl.osci.OSCIContentContainer;
import de.governikus.csl.osci.OSCIData;
import de.governikus.csl.osci.OSCISignature;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ReferenceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractOSCIData
extends AbstractOSCIContent
implements OSCIData,
Document {
    private ContentSwapFile swapFile;
    private List<OSCISignature> signatureList = new ArrayList<OSCISignature>();
    private Map<String, byte[]> digestMap = new HashMap<String, byte[]>();

    public AbstractOSCIData(OSCIContentContainer parent, String refId, ContentSwapFile swapFile) {
        super(parent, refId);
        this.swapFile = swapFile;
    }

    @Override
    public InputStream getStream() throws IOException {
        return this.swapFile.getStream();
    }

    @Override
    public long getSize() {
        return this.swapFile.getSize();
    }

    @Override
    public String getSignatureId() {
        return this.swapFile.getRefId();
    }

    @Override
    public void addSignature(OSCISignature signature) {
        this.signatureList.add(signature);
    }

    @Override
    public List<OSCISignature> getSignatures() {
        return new ArrayList<OSCISignature>(this.signatureList);
    }

    @Override
    public byte[] getDigest(String digestAlgorithm) {
        return this.digestMap.get(digestAlgorithm);
    }

    @Override
    public void setDigest(String digestAlgorithm, byte[] digest) {
        this.digestMap.put(digestAlgorithm, digest);
    }

    public InputStream getInputStream() throws IOException {
        return this.getStream();
    }

    public String getName() {
        return this.getId();
    }

    public String getContentType() {
        return null;
    }

    public ReferenceResolver getReferenceResolver() {
        return null;
    }
}

