/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.simple.xml.EnvelopedXMLSignatureValidationResult;
import de.governikus.csl.simple.xml.EnvelopedXMLSignatureValidator;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validation.policy.InvalidSignedPolicyException;
import de.governikus.csl.validation.policy.PolicyProvider;
import de.governikus.csl.validation.policy.PolicyUnmarshaller;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureFileManagerPolicyProvider
implements PolicyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureFileManagerPolicyProvider.class);
    public static final String CATEGORY_POLICY_INFIX_EIDAS_QES_TA = "eIDAS_nicht-DE_TA";
    public static final String CATEGORY_POLICY_INFIX_EIDAS_QES_TA_DE = "eIDAS_DE_QES_TA";
    public static final String CATEGORY_POLICY_INFIX_SIGG_QES_TA = "SigG_QES_TA";
    public static final String CATEGORY_POLICY_INFIX_AES_EIDAS_SIGG = "SigG_eIDAS_AES";
    public static final String CATEGORY_POLICY_EIDAS_QES_TA_EXISTENCE = "eIDAS_QES_TA_EXISTENCE";
    public static final String CATEGORY_POLICY_EIDAS_QES_TA_DE_EXISTENCE = "eIDAS_QES_TA_DE_EXISTENCE";
    public static final String CATEGORY_POLICY_EIDAS_QES_TA_QTST = "eIDAS_QES_TA_QTST";
    public static final String CATEGORY_POLICY_EIDAS_QES_TA_DE_QTST = "eIDAS_QES_TA_DE_QTST";
    public static final String CATEGORY_POLICY_INFIX_CUSTOM = "CUSTOM";
    private final CertStore allowedCertificates;
    private ValidationPolicyType eidasQesTa;
    private ValidationPolicyType eidasQesTaDe;
    private ValidationPolicyType sigGQesTa;
    private ValidationPolicyType aesEidasSigG;
    private ValidationPolicyType eidasQesTaExistence;
    private ValidationPolicyType eidasQesTaDeExistence;
    private ValidationPolicyType eidasQesTaQtst;
    private ValidationPolicyType eidasQesTaDeQtst;
    private ValidationPolicyType custom;
    private PolicyProvider defaultPolicyProvider;

    public SecureFileManagerPolicyProvider(List<? extends Certificate> allowedCertificate, PolicyProvider defaultPolicyProvider) {
        this.allowedCertificates = this.createCertStore(allowedCertificate);
        this.defaultPolicyProvider = defaultPolicyProvider;
    }

    public ValidationPolicyType addEidasQesTaPolicy(InputStream policyInputStream) throws IOException, JAXBException, InvalidSignedPolicyException {
        return this.addPolicy(policyInputStream, CATEGORY_POLICY_INFIX_EIDAS_QES_TA);
    }

    public ValidationPolicyType addEidasQesTaDePolicy(InputStream policyInputStream) throws IOException, JAXBException, InvalidSignedPolicyException {
        return this.addPolicy(policyInputStream, CATEGORY_POLICY_INFIX_EIDAS_QES_TA_DE);
    }

    public ValidationPolicyType addSigGQesTaPolicy(InputStream policyInputStream) throws IOException, JAXBException, InvalidSignedPolicyException {
        return this.addPolicy(policyInputStream, CATEGORY_POLICY_INFIX_SIGG_QES_TA);
    }

    public ValidationPolicyType addAesEidasSigGPolicy(InputStream policyInputStream) throws IOException, JAXBException, InvalidSignedPolicyException {
        return this.addPolicy(policyInputStream, CATEGORY_POLICY_INFIX_AES_EIDAS_SIGG);
    }

    public ValidationPolicyType addEidasQesTaExistencePolicy(InputStream policyInputStream) throws IOException, JAXBException, InvalidSignedPolicyException {
        return this.addPolicy(policyInputStream, CATEGORY_POLICY_EIDAS_QES_TA_EXISTENCE);
    }

    public ValidationPolicyType addEidasQesTaDeExistencePolicy(InputStream policyInputStream) throws IOException, JAXBException, InvalidSignedPolicyException {
        return this.addPolicy(policyInputStream, CATEGORY_POLICY_EIDAS_QES_TA_DE_EXISTENCE);
    }

    public ValidationPolicyType addEidasQesTaQtstPolicy(InputStream policyInputStream) throws IOException, JAXBException, InvalidSignedPolicyException {
        return this.addPolicy(policyInputStream, CATEGORY_POLICY_EIDAS_QES_TA_QTST);
    }

    public ValidationPolicyType addEidasQesTaDeQtstPolicy(InputStream policyInputStream) throws IOException, JAXBException, InvalidSignedPolicyException {
        return this.addPolicy(policyInputStream, CATEGORY_POLICY_EIDAS_QES_TA_DE_QTST);
    }

    public ValidationPolicyType addPolicy(InputStream policyInputStream, String category) throws IOException, JAXBException, InvalidSignedPolicyException {
        if (this.isInvalidCategory(category)) {
            throw new IOException(String.format("The category '%s' is not known by this implementation.", category));
        }
        byte[] data = IOUtils.toByteArray((InputStream)policyInputStream);
        ByteArrayDocument bad = new ByteArrayDocument(data);
        if (!this.checkSignature((Document)bad)) {
            throw new InvalidSignedPolicyException("Signature of policy is not valid.");
        }
        PolicyUnmarshaller policyUnmarshaller = new PolicyUnmarshaller();
        try (InputStream policyIn = bad.getInputStream();){
            ValidationPolicyType unmarshalledPolicy = policyUnmarshaller.unmarshal(policyIn);
            ValidationPolicyType validationPolicyType = this.addPolicyForCategory(unmarshalledPolicy, category);
            return validationPolicyType;
        }
    }

    private ValidationPolicyType addPolicyForCategory(ValidationPolicyType unmarshalledPolicy, String category) {
        ValidationPolicyType old = null;
        switch (category) {
            case "SigG_eIDAS_AES": {
                old = this.aesEidasSigG;
                this.aesEidasSigG = unmarshalledPolicy;
                break;
            }
            case "eIDAS_nicht-DE_TA": {
                old = this.eidasQesTa;
                this.eidasQesTa = unmarshalledPolicy;
                break;
            }
            case "eIDAS_DE_QES_TA": {
                old = this.eidasQesTaDe;
                this.eidasQesTaDe = unmarshalledPolicy;
                break;
            }
            case "SigG_QES_TA": {
                old = this.sigGQesTa;
                this.sigGQesTa = unmarshalledPolicy;
                break;
            }
            case "eIDAS_QES_TA_EXISTENCE": {
                old = this.eidasQesTaExistence;
                this.eidasQesTaExistence = unmarshalledPolicy;
                break;
            }
            case "eIDAS_QES_TA_DE_EXISTENCE": {
                old = this.eidasQesTaDeExistence;
                this.eidasQesTaDeExistence = unmarshalledPolicy;
                break;
            }
            case "eIDAS_QES_TA_QTST": {
                old = this.eidasQesTaQtst;
                this.eidasQesTaQtst = unmarshalledPolicy;
                break;
            }
            case "eIDAS_QES_TA_DE_QTST": {
                old = this.eidasQesTaDeQtst;
                this.eidasQesTaDeQtst = unmarshalledPolicy;
                break;
            }
            case "CUSTOM": {
                old = this.custom;
                this.custom = unmarshalledPolicy;
                break;
            }
        }
        return old;
    }

    private boolean checkSignature(Document doc) throws IOException {
        if (this.allowedCertificates == null) {
            return false;
        }
        try (InputStream is = doc.getInputStream();){
            EnvelopedXMLSignatureValidator validator = new EnvelopedXMLSignatureValidator(this.allowedCertificates);
            EnvelopedXMLSignatureValidationResult validateResult = validator.validate(is);
            boolean bl = validateResult.isSignatureValid() && validateResult.isWholeDocumentSigned();
            return bl;
        }
    }

    private boolean isInvalidCategory(String category) {
        switch (category) {
            case "SigG_eIDAS_AES": 
            case "eIDAS_nicht-DE_TA": 
            case "eIDAS_DE_QES_TA": 
            case "SigG_QES_TA": 
            case "eIDAS_QES_TA_EXISTENCE": 
            case "eIDAS_QES_TA_DE_EXISTENCE": 
            case "eIDAS_QES_TA_QTST": 
            case "eIDAS_QES_TA_DE_QTST": 
            case "CUSTOM": {
                return false;
            }
        }
        return true;
    }

    private ValidationPolicyType cloneInstance(ValidationPolicyType policy) {
        if (policy == null) {
            return null;
        }
        LOGGER.debug("Using signed policy {}.", (Object)this.getPolicyName(policy, "EN"));
        return policy.cloneInstance();
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA() {
        return this.getOrDefault(this.cloneInstance(this.eidasQesTa), this.defaultPolicyProvider::getEIDAS_QES_TA, CATEGORY_POLICY_INFIX_EIDAS_QES_TA);
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_DE() {
        return this.getOrDefault(this.cloneInstance(this.eidasQesTaDe), this.defaultPolicyProvider::getEIDAS_QES_TA_DE, CATEGORY_POLICY_INFIX_EIDAS_QES_TA_DE);
    }

    @Override
    public ValidationPolicyType getSigG_QES_TA() {
        return this.getOrDefault(this.cloneInstance(this.sigGQesTa), this.defaultPolicyProvider::getSigG_QES_TA, CATEGORY_POLICY_INFIX_SIGG_QES_TA);
    }

    @Override
    public ValidationPolicyType getAES_eIDAS_SigG() {
        return this.getOrDefault(this.cloneInstance(this.aesEidasSigG), this.defaultPolicyProvider::getAES_eIDAS_SigG, CATEGORY_POLICY_INFIX_AES_EIDAS_SIGG);
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_POE_Existence() {
        return this.getOrDefault(this.cloneInstance(this.eidasQesTaExistence), this.defaultPolicyProvider::getEIDAS_QES_TA_POE_Existence, CATEGORY_POLICY_EIDAS_QES_TA_EXISTENCE);
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_DE_POE_Existence() {
        return this.getOrDefault(this.cloneInstance(this.eidasQesTaDeExistence), this.defaultPolicyProvider::getEIDAS_QES_TA_DE_POE_Existence, CATEGORY_POLICY_EIDAS_QES_TA_DE_EXISTENCE);
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_POE_QTST() {
        return this.getOrDefault(this.cloneInstance(this.eidasQesTaQtst), this.defaultPolicyProvider::getEIDAS_QES_TA_POE_QTST, CATEGORY_POLICY_EIDAS_QES_TA_QTST);
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_DE_POE_QTST() {
        return this.getOrDefault(this.cloneInstance(this.eidasQesTaDeQtst), this.defaultPolicyProvider::getEIDAS_QES_TA_DE_POE_QTST, CATEGORY_POLICY_EIDAS_QES_TA_DE_QTST);
    }

    public ValidationPolicyType getCustom() {
        return this.cloneInstance(this.custom);
    }

    @Override
    public List<ValidationPolicyType> getAllPolicies() {
        return Arrays.asList(this.getEIDAS_QES_TA(), this.getEIDAS_QES_TA_DE(), this.getSigG_QES_TA(), this.getAES_eIDAS_SigG(), this.getEIDAS_QES_TA_POE_Existence(), this.getEIDAS_QES_TA_DE_POE_Existence(), this.getEIDAS_QES_TA_POE_QTST(), this.getEIDAS_QES_TA_DE_POE_QTST());
    }

    @Override
    public boolean isUsable() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return this.eidasQesTa != null && this.eidasQesTaDe != null && this.sigGQesTa != null && this.aesEidasSigG != null && this.eidasQesTaExistence != null && this.eidasQesTaDeExistence != null && this.eidasQesTaQtst != null && this.eidasQesTaDeQtst != null;
    }

    private ValidationPolicyType getOrDefault(ValidationPolicyType policy, Supplier<? extends ValidationPolicyType> defaultPolicySupplier, String policyCategory) {
        if (policy != null) {
            return policy;
        }
        LOGGER.debug("SecureFileManagerPolicyProvider is missing a signed policy for category 'POLICY_{}'! Returning the policy from the DefaultPolicyProvider instead.", (Object)policyCategory);
        return defaultPolicySupplier.get();
    }

    private CertStore createCertStore(List<? extends Certificate> allowedCertificates) {
        List<? extends Certificate> certs = allowedCertificates;
        if (certs == null) {
            certs = new ArrayList<Certificate>();
        }
        CollectionCertStoreParameters certStoreParameters = new CollectionCertStoreParameters(certs);
        try {
            return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, CryptoProviderUtil.PROVIDER);
        }
        catch (Exception e) {
            try {
                return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, "BC");
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private String getPolicyName(ValidationPolicyType policy, String lang) {
        if (policy != null && policy.getPolicyInformation() != null) {
            return policy.getPolicyInformation().getPolicyName(lang);
        }
        return "[UNKNOWN POLICY NAME]";
    }
}

