/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.validation.policy.DefaultPolicyProvider;
import de.governikus.csl.validation.policy.PolicyProvider;
import de.governikus.csl.validation.policy.SecureFileManagerPolicyProvider;
import java.security.cert.Certificate;
import java.util.List;

public class PolicyProviderManager {
    protected DefaultPolicyProvider defaultPolicyProvider = new DefaultPolicyProvider();
    protected SecureFileManagerPolicyProvider fmPolicyProvider;

    public PolicyProviderManager(List<? extends Certificate> trustedPolicyIssuers) {
        this.fmPolicyProvider = new SecureFileManagerPolicyProvider(trustedPolicyIssuers, this.defaultPolicyProvider);
    }

    public PolicyProviderManager() {
        this.fmPolicyProvider = new SecureFileManagerPolicyProvider(null, this.defaultPolicyProvider);
    }

    public PolicyProvider getPolicyProvider() {
        return this.fmPolicyProvider == null || !this.fmPolicyProvider.isUsable() ? this.defaultPolicyProvider : this.fmPolicyProvider;
    }

    public PolicyProvider getDefaultPolicyProvider() {
        return this.defaultPolicyProvider;
    }

    public SecureFileManagerPolicyProvider getFileManagerPolicyProvider() {
        return this.fmPolicyProvider;
    }
}

