/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.uom.util.SwapFileOutputStream;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.validation.policy.PolicySchemaValidator;
import de.governikus.csl.validation.policy.PolicyUnmarshaller;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class PolicyParser {
    private PolicyUnmarshaller unmarshaller;
    private PolicySchemaValidator validator = PolicySchemaValidator.createInstance();
    private TempDataManager tempDataManager;

    public PolicyParser(TempDataManager tempDataManager) throws SAXException {
        this.unmarshaller = new PolicyUnmarshaller();
        this.tempDataManager = tempDataManager;
    }

    /*
     * Loose catch block
     */
    public ValidationPolicyType parse(InputStream policyStream) throws IOException, SAXException, JAXBException, XMLStreamException {
        if (policyStream == null) {
            throw new NullPointerException("Missing input stream!");
        }
        TempDataManager childManager = this.tempDataManager.createChildManager();
        File tempFile = childManager.createTempFile("data", "tmp");
        try {
            try (SwapFileOutputStream swapFileOS = new SwapFileOutputStream(tempFile, 32768);){
                swapFileOS.consume(policyStream);
                this.validator.validateStream(swapFileOS.getInputStream());
                ValidationPolicyType validationPolicyType = this.unmarshaller.unmarshal(swapFileOS.getInputStream());
                return validationPolicyType;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            childManager.cleanUp();
        }
    }
}

