/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.uom.validate.PolicyEvaluationState;
import de.governikus.csl.uom.validate.PolicyOrigin;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.validation.policy.EvaluatedValidationPolicyType;
import de.governikus.csl.validation.policy.PolicyEvaluatorKey;
import de.governikus.csl.validation.policy.PolicyProviderManager;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.HashMap;

public class PolicyEvaluator {
    private final PolicyProviderManager policyProviderManager;

    public PolicyEvaluator(PolicyProviderManager policyProviderManager) {
        if (policyProviderManager == null) {
            throw new IllegalArgumentException("PolicyProviderManager must not be null");
        }
        this.policyProviderManager = policyProviderManager;
    }

    public PolicyEvaluationState evaluatePolicy(ValidationPolicyType policy) {
        PolicyEvaluatorKey key = new PolicyEvaluatorKey(policy);
        HashMap policyMap = new HashMap();
        this.policyProviderManager.getPolicyProvider().getAllPolicies().stream().forEach(e -> policyMap.put(new PolicyEvaluatorKey((ValidationPolicyType)e), e));
        ValidatePolicy p = (ValidatePolicy)policyMap.get(key);
        if (p == null) {
            return PolicyEvaluationState.CUSTOM_POLICY;
        }
        return PolicyEvaluationState.TRUSTED_POLICY;
    }

    public EvaluatedValidationPolicyType createEvaluatedPolicy(ValidationPolicyType policy, PolicyOrigin origin) {
        return this.createEvaluatedPolicy(policy, origin, false);
    }

    public EvaluatedValidationPolicyType createEvaluatedPolicy(ValidationPolicyType policy, PolicyOrigin origin, boolean evaluate) {
        EvaluatedValidationPolicyType result = new EvaluatedValidationPolicyType();
        result.setPolicyOrigin(origin);
        result.setPolicy(policy);
        if (evaluate) {
            result.setEvaluationState(this.evaluatePolicy(policy));
        }
        return result;
    }

    public static PolicyEvaluationState evaluatePolicy(ValidationPolicyType policy, PolicyProviderManager policyProviderManager) {
        return new PolicyEvaluator(policyProviderManager).evaluatePolicy(policy);
    }

    public static EvaluatedValidationPolicyType createEvaluatedPolicy(ValidationPolicyType policy, PolicyOrigin origin, PolicyProviderManager policyProviderManager) {
        return new PolicyEvaluator(policyProviderManager).createEvaluatedPolicy(policy, origin);
    }

    public static EvaluatedValidationPolicyType createEvaluatedPolicy(ValidationPolicyType policy, PolicyOrigin origin, boolean evaluate, PolicyProviderManager policyProviderManager) {
        return new PolicyEvaluator(policyProviderManager).createEvaluatedPolicy(policy, origin, evaluate);
    }
}

