/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.policy;

import de.governikus.csl.uom.ResourceUtil;
import de.governikus.csl.validation.policy.PolicyProvider;
import de.governikus.csl.validation.policy.PolicyUnmarshaller;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPolicyProvider
implements PolicyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolicyProvider.class);
    private static final String LOG_MSG_WHICH_POLICY = "Using policy from JAR resources [{}].";
    private static final String POLICY_NAME_LANG = "EN";
    public static final String RESOURCE_POLICY_EIDAS_QES_TA_XML = "policyfiles/eIDAS_QES_with_TA.xml";
    public static final String RESOURCE_POLICY_EIDAS_QES_TA_DE_XML = "policyfiles/eIDAS_QES_with_TA_DE.xml";
    public static final String RESOURCE_POLICY_SIGG_QES_TA_XML = "policyfiles/SigG_QES_with_TA.xml";
    public static final String RESOURCE_POLICY_AES_EIDAS_SIGG_XML = "policyfiles/AES_eIDAS_SigG.xml";
    public static final String RESOURCE_POLICY_EIDAS_QES_TA_POE_EXISTENCE_XML = "policyfiles/qes_eidas_ta_existence.xml";
    public static final String RESOURCE_POLICY_EIDAS_QES_TA_DE_POE_EXISTENCE_XML = "policyfiles/qes_eidas_ta_de_existence.xml";
    public static final String RESOURCE_POLICY_EIDAS_QES_TA_POE_QTST = "policyfiles/qes_eidas_ta_poe_qtst.xml";
    public static final String RESOURCE_POLICY_EIDAS_QES_TA_DE_POE_QTST = "policyfiles/qes_eidas_ta_de_poe_qtst.xml";
    private static final ValidationPolicyType EIDAS_QES_TA;
    private static final ValidationPolicyType EIDAS_QES_TA_DE;
    private static final ValidationPolicyType SIG_G_QES_TA;
    private static final ValidationPolicyType AES_EIDAS_SIGG;
    private static final ValidationPolicyType EIDAS_QES_TA_POE_EXISTENCE;
    private static final ValidationPolicyType EIDAS_QES_TA_DE_POE_EXISTENCE;
    private static final ValidationPolicyType EIDAS_QES_TA_POE_QTST;
    private static final ValidationPolicyType EIDAS_QES_TA_DE_POE_QTST;

    static ValidationPolicyType loadPolicy(InputStream policyStream) throws IOException, JAXBException {
        if (policyStream == null) {
            throw new IOException("policy stream unreadable");
        }
        try (InputStream is = policyStream;){
            PolicyUnmarshaller policyUnmarshaller = new PolicyUnmarshaller();
            ValidationPolicyType validationPolicyType = policyUnmarshaller.unmarshal(policyStream);
            return validationPolicyType;
        }
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA() {
        LOGGER.debug(LOG_MSG_WHICH_POLICY, (Object)this.getPolicyName(EIDAS_QES_TA, POLICY_NAME_LANG));
        return EIDAS_QES_TA.cloneInstance();
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_DE() {
        LOGGER.debug(LOG_MSG_WHICH_POLICY, (Object)this.getPolicyName(EIDAS_QES_TA_DE, POLICY_NAME_LANG));
        return EIDAS_QES_TA_DE.cloneInstance();
    }

    @Override
    public ValidationPolicyType getSigG_QES_TA() {
        LOGGER.debug(LOG_MSG_WHICH_POLICY, (Object)this.getPolicyName(SIG_G_QES_TA, POLICY_NAME_LANG));
        return SIG_G_QES_TA.cloneInstance();
    }

    @Override
    public ValidationPolicyType getAES_eIDAS_SigG() {
        LOGGER.debug(LOG_MSG_WHICH_POLICY, (Object)this.getPolicyName(AES_EIDAS_SIGG, POLICY_NAME_LANG));
        return AES_EIDAS_SIGG.cloneInstance();
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_POE_Existence() {
        LOGGER.debug(LOG_MSG_WHICH_POLICY, (Object)this.getPolicyName(EIDAS_QES_TA_POE_EXISTENCE, POLICY_NAME_LANG));
        return EIDAS_QES_TA_POE_EXISTENCE.cloneInstance();
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_DE_POE_Existence() {
        LOGGER.debug(LOG_MSG_WHICH_POLICY, (Object)this.getPolicyName(EIDAS_QES_TA_DE_POE_EXISTENCE, POLICY_NAME_LANG));
        return EIDAS_QES_TA_DE_POE_EXISTENCE.cloneInstance();
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_POE_QTST() {
        LOGGER.debug(LOG_MSG_WHICH_POLICY, (Object)this.getPolicyName(EIDAS_QES_TA_POE_QTST, POLICY_NAME_LANG));
        return EIDAS_QES_TA_POE_QTST.cloneInstance();
    }

    @Override
    public ValidationPolicyType getEIDAS_QES_TA_DE_POE_QTST() {
        LOGGER.debug(LOG_MSG_WHICH_POLICY, (Object)this.getPolicyName(EIDAS_QES_TA_DE_POE_QTST, POLICY_NAME_LANG));
        return EIDAS_QES_TA_DE_POE_QTST.cloneInstance();
    }

    @Override
    public List<ValidationPolicyType> getAllPolicies() {
        ArrayList<ValidationPolicyType> result = new ArrayList<ValidationPolicyType>();
        result.add(this.getEIDAS_QES_TA());
        result.add(this.getEIDAS_QES_TA_DE());
        result.add(this.getSigG_QES_TA());
        result.add(this.getAES_eIDAS_SigG());
        result.add(this.getEIDAS_QES_TA_POE_Existence());
        result.add(this.getEIDAS_QES_TA_DE_POE_Existence());
        result.add(this.getEIDAS_QES_TA_POE_QTST());
        result.add(this.getEIDAS_QES_TA_DE_POE_QTST());
        return result;
    }

    @Override
    public boolean isUsable() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    private String getPolicyName(ValidationPolicyType policy, String lang) {
        if (policy.getPolicyInformation() != null) {
            return policy.getPolicyInformation().getPolicyName(lang);
        }
        return "[UNKNOWN POLICY NAME]";
    }

    static {
        try {
            EIDAS_QES_TA = DefaultPolicyProvider.loadPolicy(ResourceUtil.getResourceAsStream((String)RESOURCE_POLICY_EIDAS_QES_TA_XML));
            EIDAS_QES_TA_DE = DefaultPolicyProvider.loadPolicy(ResourceUtil.getResourceAsStream((String)RESOURCE_POLICY_EIDAS_QES_TA_DE_XML));
            SIG_G_QES_TA = DefaultPolicyProvider.loadPolicy(ResourceUtil.getResourceAsStream((String)RESOURCE_POLICY_SIGG_QES_TA_XML));
            AES_EIDAS_SIGG = DefaultPolicyProvider.loadPolicy(ResourceUtil.getResourceAsStream((String)RESOURCE_POLICY_AES_EIDAS_SIGG_XML));
            EIDAS_QES_TA_POE_EXISTENCE = DefaultPolicyProvider.loadPolicy(ResourceUtil.getResourceAsStream((String)RESOURCE_POLICY_EIDAS_QES_TA_POE_EXISTENCE_XML));
            EIDAS_QES_TA_DE_POE_EXISTENCE = DefaultPolicyProvider.loadPolicy(ResourceUtil.getResourceAsStream((String)RESOURCE_POLICY_EIDAS_QES_TA_DE_POE_EXISTENCE_XML));
            EIDAS_QES_TA_POE_QTST = DefaultPolicyProvider.loadPolicy(ResourceUtil.getResourceAsStream((String)RESOURCE_POLICY_EIDAS_QES_TA_POE_QTST));
            EIDAS_QES_TA_DE_POE_QTST = DefaultPolicyProvider.loadPolicy(ResourceUtil.getResourceAsStream((String)RESOURCE_POLICY_EIDAS_QES_TA_DE_POE_QTST));
        }
        catch (IOException | JAXBException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

