/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.circuitbreaker;

import de.governikus.csl.validation.circuitbreaker.CircuitBreaker;
import de.governikus.csl.validation.circuitbreaker.CircuitBreakerOptions;
import de.governikus.csl.validation.circuitbreaker.ManagedCircuitBreaker;
import de.governikus.csl.validation.circuitbreaker.ManagedClosedCircuitBreaker;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CircuitBreakerManager.class);
    private Map<String, CircuitBreaker> circuitBreakers;
    private CircuitBreakerOptions options;

    public CircuitBreakerManager(CircuitBreakerOptions options) {
        this.options = options;
        this.circuitBreakers = new ConcurrentHashMap<String, CircuitBreaker>();
    }

    public CircuitBreaker get(String url) {
        CircuitBreaker circuitBreaker = this.circuitBreakers.get(url);
        if (circuitBreaker != null) {
            return circuitBreaker;
        }
        return new ManagedClosedCircuitBreaker(this, url);
    }

    void reportFailure(String url) {
        LOGGER.info("Adding circuit breaker for url {}", (Object)url);
        ManagedCircuitBreaker cb = new ManagedCircuitBreaker(this, url, this.options);
        cb.reportFailure();
        this.circuitBreakers.put(url, cb);
    }

    void remove(String url) {
        LOGGER.info("Removing circuit breaker for url {}", (Object)url);
        this.circuitBreakers.remove(url);
    }

    public Set<String> getUrls() {
        return this.circuitBreakers.keySet();
    }
}

