/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.circuitbreaker;

import de.governikus.csl.validation.circuitbreaker.CircuitBreaker;
import de.governikus.csl.validation.circuitbreaker.CircuitBreakerOptions;
import de.governikus.csl.validation.circuitbreaker.CircuitBreakerState;
import java.io.IOException;

public class CircuitBreakerImpl
implements CircuitBreaker {
    public static final short STATE_CLOSED = 1;
    public static final short STATE_HALF_OPEN = 2;
    public static final short STATE_OPEN = 3;
    private CircuitBreakerOptions options;
    private CircuitBreakerState state = CircuitBreakerState.CLOSED;
    private long openSince;
    private int successfullExecutionsInHalfOpenState = 0;
    private int lives = 0;

    public CircuitBreakerImpl(CircuitBreakerOptions options) {
        this.options = options;
        this.lives = options.getFailThreshold();
    }

    @Override
    public void check() throws IOException {
        if (this.state == CircuitBreakerState.OPEN) {
            long now = System.currentTimeMillis();
            if (now > this.openSince + this.options.getDelay()) {
                this.state = CircuitBreakerState.HALF_OPEN;
                this.successfullExecutionsInHalfOpenState = 0;
                return;
            }
            throw new IOException("Open circuit breaker");
        }
    }

    @Override
    public CircuitBreakerState reportSuccess() {
        if (this.state == CircuitBreakerState.HALF_OPEN) {
            ++this.successfullExecutionsInHalfOpenState;
            if (this.successfullExecutionsInHalfOpenState >= this.options.getSuccessThreshold()) {
                this.state = CircuitBreakerState.CLOSED;
                this.lives = this.options.getFailThreshold();
            }
        } else if (this.state == CircuitBreakerState.CLOSED && this.lives < this.options.getFailThreshold()) {
            ++this.lives;
        }
        return this.state;
    }

    @Override
    public CircuitBreakerState reportFailure() {
        if (this.state == CircuitBreakerState.CLOSED) {
            --this.lives;
            if (this.lives <= 0) {
                this.state = CircuitBreakerState.OPEN;
                this.openSince = System.currentTimeMillis();
            }
        } else if (this.state == CircuitBreakerState.HALF_OPEN) {
            this.state = CircuitBreakerState.OPEN;
            this.openSince = System.currentTimeMillis();
        }
        return this.state;
    }
}

