/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.utils.RingBuffer;
import java.io.IOException;
import java.io.InputStream;

public class RingBufferedInputStream
extends InputStream {
    private InputStream stream;
    private RingBuffer<Integer> buffer;
    private int numBytesFromBufferToRead;

    public RingBufferedInputStream(InputStream is, int size) {
        this.stream = is;
        this.buffer = new RingBuffer<Integer>(new Integer[size]);
        this.numBytesFromBufferToRead = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.numBytesFromBufferToRead > 0) {
            Integer read = this.buffer.read();
            --this.numBytesFromBufferToRead;
            return read;
        }
        int r = this.stream.read();
        if (r < 0) {
            return -1;
        }
        this.buffer.write(r);
        return r;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.stream.close();
    }

    public boolean rewind() {
        ++this.numBytesFromBufferToRead;
        return true;
    }
}

