/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

public class RingBuffer<T> {
    private T[] buffer;
    private int readPtr = 0;
    private int writePtr = 0;
    private int maxIndex;
    private int dataToRead = 0;
    private boolean completelyWritten = false;

    public RingBuffer(T[] buffer) {
        this.maxIndex = buffer.length - 1;
        this.buffer = buffer;
    }

    public T read() {
        if (this.writePtr == this.readPtr || this.dataToRead == 0) {
            return null;
        }
        T t = this.buffer[this.readPtr];
        this.readPtr = this.incrementPtr(this.readPtr);
        --this.dataToRead;
        return t;
    }

    public void write(T t) {
        this.buffer[this.writePtr] = t;
        this.writePtr = this.incrementPtr(this.writePtr);
        ++this.dataToRead;
        if (this.writePtr == 0) {
            this.completelyWritten = true;
        }
        if (this.writePtr == this.readPtr) {
            this.readPtr = this.incrementPtr(this.readPtr);
            this.dataToRead = this.maxIndex + 1;
        }
    }

    public boolean goBack() {
        if (this.readPtr == this.writePtr) {
            return false;
        }
        int r = this.decrementPtr(this.readPtr);
        if (r < 0 && !this.completelyWritten) {
            return false;
        }
        if (r == this.writePtr) {
            return false;
        }
        this.readPtr = r;
        return true;
    }

    private int incrementPtr(int ptr) {
        int r = ptr + 1;
        if (r > this.maxIndex) {
            return 0;
        }
        return r;
    }

    private int decrementPtr(int ptr) {
        int r = ptr - 1;
        if (r < 0) {
            return this.maxIndex;
        }
        return r;
    }
}

