/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class LdapURL {
    private URI uri;
    private String dn;
    private List<String> attributes = new ArrayList<String>();
    private String scope;
    private String filter;
    private String providerURL;

    public LdapURL(String url) throws URISyntaxException {
        this.parse(url);
        URI i = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.getPort(), this.uri.getPath(), null, null);
        this.providerURL = i.toString();
    }

    private void parse(String url) throws URISyntaxException {
        this.uri = new URI(url);
        String scheme = this.uri.getScheme();
        if (!scheme.equalsIgnoreCase("ldap") && !scheme.equalsIgnoreCase("ldaps")) {
            throw new URISyntaxException(url, "This implementation only supports ldap or ldaps urls");
        }
        String path = this.uri.getRawPath();
        if (path != null && !path.isEmpty()) {
            this.dn = path = path.startsWith("/") ? path.substring(1) : path;
            String query = this.uri.getQuery();
            if (query == null || query.isEmpty()) {
                return;
            }
            String[] split = (query = query.startsWith("/") ? query.substring(1) : query).split("\\?");
            if (split.length >= 1) {
                this.parseAttributes(split[0]);
            }
            if (split.length >= 2) {
                this.scope = split[1];
            }
            if (split.length >= 3) {
                this.filter = split[2];
            }
        }
    }

    private void parseAttributes(String attributeString) {
        if (attributeString != null && !attributeString.isEmpty()) {
            String[] split;
            for (String attrib : split = attributeString.split(",")) {
                this.attributes.add(attrib);
            }
        }
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public int getPort() {
        int port = this.uri.getPort();
        if (port <= 0) {
            switch (this.getScheme().toLowerCase()) {
                case "ldap": {
                    port = 389;
                    break;
                }
                case "ldaps": {
                    port = 636;
                    break;
                }
            }
        }
        return port;
    }

    public String getDN() {
        return this.dn;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFilter() {
        return this.filter;
    }
}

