/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestUtil {
    private static final String LOG_MSG_UNKNOWN_DIGEST_ALGORITHM = "Can't find digest algorithm: {}";
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestUtil.class);

    public static byte[] createHashQuietly(StreamProvider data, AlgorithmIdentifier digestAlgorithm) {
        try {
            return DigestUtil.createHash(data, digestAlgorithm);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e1) {
            LOGGER.info(LOG_MSG_UNKNOWN_DIGEST_ALGORITHM, (Object)digestAlgorithm.getJCAName(), (Object)e1);
        }
        catch (IOException e2) {
            LOGGER.info("Can't read data", (Throwable)e2);
        }
        return new byte[0];
    }

    public static byte[] createHash(StreamProvider data, AlgorithmIdentifier digestAlgorithm) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
        DigestUtil.extendMessageDigest(data, md);
        return md.digest();
    }

    public static byte[] createHashQuietly(StreamProvider data, DigestAlgorithm digestAlgorithm) {
        try {
            return DigestUtil.createHash(data, digestAlgorithm);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e1) {
            LOGGER.info(LOG_MSG_UNKNOWN_DIGEST_ALGORITHM, (Object)digestAlgorithm.getJCAName(), (Object)e1);
        }
        catch (IOException e2) {
            LOGGER.info("Can't read data", (Throwable)e2);
        }
        return new byte[0];
    }

    public static byte[] createHash(StreamProvider data, DigestAlgorithm digestAlgorithm) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
        DigestUtil.extendMessageDigest(data, md);
        return md.digest();
    }

    private static void extendMessageDigest(StreamProvider data, MessageDigest md) throws IOException {
        if (data != null) {
            try (InputStream dataToCheck = data.getInputStream();){
                int bufferSize = 1024;
                byte[] buffer = new byte[bufferSize];
                int read = 0;
                while ((read = dataToCheck.read(buffer)) > 0) {
                    md.update(buffer, 0, read);
                }
            }
        }
    }

    public static byte[] createHash(DigestAlgorithm digestAlgorithm, StreamProvider ... data) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
        for (StreamProvider sp : data) {
            DigestUtil.extendMessageDigest(sp, md);
        }
        return md.digest();
    }

    public static byte[] createHash(DigestAlgorithm digestAlgorithm, List<? extends StreamProvider> data) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
        for (StreamProvider streamProvider : data) {
            DigestUtil.extendMessageDigest(streamProvider, md);
        }
        return md.digest();
    }

    public static byte[] createHash(byte[] data, AlgorithmIdentifier digestAlgorithm) {
        try {
            MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
            return md.digest(data);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e1) {
            LOGGER.info(LOG_MSG_UNKNOWN_DIGEST_ALGORITHM, (Object)digestAlgorithm.getJCAName(), (Object)e1);
            return new byte[0];
        }
    }

    public static byte[] createHash(byte[] data, DigestAlgorithm digestAlgorithm) {
        try {
            MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
            return md.digest(data);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e1) {
            LOGGER.info(LOG_MSG_UNKNOWN_DIGEST_ALGORITHM, (Object)digestAlgorithm.getJCAName(), (Object)e1);
            return new byte[0];
        }
    }

    public static byte[] createHash(List<byte[]> data, AlgorithmIdentifier digestAlgorithm) {
        MessageDigest md = null;
        try {
            md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
            for (byte[] hash : data) {
                md.update(hash);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.warn("Can't create message digest", (Throwable)e);
            return new byte[0];
        }
    }

    public static byte[] createHash(List<byte[]> data, DigestAlgorithm digestAlgorithm) {
        MessageDigest md = null;
        try {
            md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
            for (byte[] hash : data) {
                md.update(hash);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.warn("Can't create message digest", (Throwable)e);
            return new byte[0];
        }
    }

    public static byte[] createHashQuietly(DigestAlgorithm digestAlgorithm, byte[] ... data) {
        try {
            return DigestUtil.createHash(digestAlgorithm, data);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOGGER.warn("Can't create message digest", (Throwable)e);
            return new byte[0];
        }
    }

    public static byte[] createHash(DigestAlgorithm digestAlgorithm, byte[] ... data) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm.getJCAName());
        for (byte[] hash : data) {
            md.update(hash);
        }
        return md.digest();
    }
}

