/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.PolicyInformation;
import de.bos_bremen.ci.asn1.x509.QCStatement;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateUtil.class);

    public List<QCStatement> getQCStatements(X509Certificate cert) {
        byte[] qcStatementBytes = cert.getExtensionValue("1.3.6.1.5.5.7.1.3");
        if (qcStatementBytes != null) {
            try {
                OCTETSTRING os = new OCTETSTRING(Run.create((Source)new BSource(qcStatementBytes)));
                Run run = Run.create((Source)new BSource(os.getOctets()));
                byte tag = run.next();
                if (tag != 48) {
                    // empty if block
                }
                ArrayList<QCStatement> qcStatements = new ArrayList<QCStatement>();
                int end = run.pos() + run.readLength();
                while (run.pos() < end) {
                    QCStatement ad = new QCStatement(run);
                    qcStatements.add(ad);
                }
                return qcStatements;
            }
            catch (ParseException e) {
                LOGGER.error("Can't parse qc statement in certificate", (Throwable)e);
            }
        }
        return null;
    }

    public List<PolicyInformation> getCertificatePolicies(X509Certificate cert) {
        byte[] certificatePoliciesBytes = cert.getExtensionValue("2.5.29.32");
        if (certificatePoliciesBytes == null) {
            certificatePoliciesBytes = cert.getExtensionValue("2.5.29.3");
        }
        if (certificatePoliciesBytes != null) {
            try {
                OCTETSTRING os = new OCTETSTRING(Run.create((Source)new BSource(certificatePoliciesBytes)));
                Run run = Run.create((Source)new BSource(os.getOctets()));
                byte tag = run.next();
                if (tag != 48) {
                    // empty if block
                }
                ArrayList<PolicyInformation> policyInformations = new ArrayList<PolicyInformation>();
                int end = run.pos() + run.readLength();
                while (run.pos() < end) {
                    PolicyInformation pi = new PolicyInformation(run);
                    policyInformations.add(pi);
                }
                return policyInformations;
            }
            catch (ParseException e) {
                LOGGER.error("Can't parse policy information");
            }
        }
        return null;
    }

    public ExtendedKeyUsage getExtendedKeyUsage(X509Certificate cert) {
        byte[] extensionValue = cert.getExtensionValue("2.5.29.37");
        if (extensionValue == null) {
            return null;
        }
        try {
            ASN1OctetString octet = ASN1OctetString.getInstance((Object)extensionValue);
            ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)octet.getOctets());
            return extendedKeyUsage;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getFormattedCertDataString(byte[] certBytes) {
        StringBuilder sb = new StringBuilder();
        if (certBytes != null && certBytes.length != 0) {
            String certData = DatatypeConverter.printHexBinary((byte[])certBytes);
            for (int i = 0; i < certData.length() / 80; ++i) {
                sb.append(certData.substring(i * 80, i * 80 + 80));
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

