/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.utils;

import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.core.impl.SignedFileAccessor;
import java.io.File;
import java.net.URL;

public abstract class AbstractDocumentParser<T> {
    public T loadDocument(String filename) throws Exception {
        File f = new File(filename);
        if (f.isAbsolute()) {
            return this.loadDocument(f);
        }
        URL url = this.getClass().getResource(filename);
        return this.loadDocument(new File(url.getFile()));
    }

    public T loadDocument(File signatureFile) throws Exception {
        return this.loadDocument(signatureFile, null);
    }

    public T loadDocument(File signatureFile, File contentFile) throws Exception {
        return this.loadDocument((SignedData)new SignedFileAccessor(signatureFile, contentFile));
    }

    public abstract T loadDocument(SignedData var1) throws Exception;
}

