/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl.qualifier;

import de.governikus.csl.tsl.qualifier.QualifierCriterion;
import de.governikus.csl.tsl.uris.ServiceQualifier;
import java.security.cert.X509Certificate;
import java.util.List;

public class Qualifier {
    private List<ServiceQualifier> qualifiers;
    private List<QualifierCriterion> criteria;
    private String assertion;

    public Qualifier(List<ServiceQualifier> qualifiers, List<QualifierCriterion> criteria, String assertion) {
        this.qualifiers = qualifiers;
        this.criteria = criteria;
        this.assertion = assertion;
    }

    public List<ServiceQualifier> getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(List<ServiceQualifier> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public List<QualifierCriterion> getCriteria() {
        return this.criteria;
    }

    public String getAssertion() {
        return this.assertion;
    }

    public void setCriteria(List<QualifierCriterion> criteria) {
        this.criteria = criteria;
    }

    public boolean isApplicable(X509Certificate cert) {
        if (this.criteria != null && !this.criteria.isEmpty()) {
            boolean positiveResultRequired = true;
            boolean all = true;
            if (this.assertion.equalsIgnoreCase("atLeastOne")) {
                all = false;
            } else if (this.assertion.equalsIgnoreCase("none")) {
                positiveResultRequired = false;
            }
            for (QualifierCriterion qc : this.criteria) {
                boolean result = qc.matches(cert);
                boolean bl = result = result == positiveResultRequired;
                if (all && !result) {
                    return false;
                }
                if (all || !result) continue;
                return true;
            }
            return all;
        }
        return true;
    }
}

