/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl.qualifier;

import de.bos_bremen.ci.asn1.x509.PolicyInformation;
import de.governikus.csl.tsl.qualifier.QualifierCriterion;
import de.governikus.csl.utils.CertificateUtil;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.etsi.uri._01903.v1_3.ObjectIdentifierType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.PoliciesListType;

public class PolicyCriterion
extends CertificateUtil
implements QualifierCriterion {
    private List<String> requiredPolicyOIDs = new ArrayList<String>();

    public PolicyCriterion(PoliciesListType policy) {
        List policyIdentifier = policy.getPolicyIdentifier();
        for (ObjectIdentifierType identifier : policyIdentifier) {
            String oid = identifier.getIdentifier().getValue();
            this.requiredPolicyOIDs.add(oid);
        }
    }

    @Override
    public boolean matches(X509Certificate c) {
        List<PolicyInformation> certificatePolicies = this.getCertificatePolicies(c);
        if (certificatePolicies == null) {
            return this.requiredPolicyOIDs.isEmpty();
        }
        for (String oid : this.requiredPolicyOIDs) {
            boolean exist = false;
            for (PolicyInformation policy : certificatePolicies) {
                if (!policy.getCertPolicyId().getOID().equals(oid)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            return false;
        }
        return true;
    }

    @Generated
    public List<String> getRequiredPolicyOIDs() {
        return this.requiredPolicyOIDs;
    }
}

