/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl.qualifier;

import de.governikus.csl.tsl.qualifier.QualifierCriterion;
import de.governikus.csl.uom.validate.KeyUsage;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.KeyUsageBitType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.KeyUsageType;

public class KeyUsageCriterion
implements QualifierCriterion {
    private Map<KeyUsage, Boolean> requiredSettings = new HashMap<KeyUsage, Boolean>();

    public KeyUsageCriterion(KeyUsageType keyUsage) {
        List keyUsageBits = keyUsage.getKeyUsageBit();
        for (KeyUsageBitType keyUsageBit : keyUsageBits) {
            String name = keyUsageBit.getName();
            boolean isSet = keyUsageBit.isValue();
            KeyUsage usage = null;
            if (name.equalsIgnoreCase("digitalSignature")) {
                usage = KeyUsage.DIGITAL_SIGNATURE;
            } else if (name.equalsIgnoreCase("nonRepudiation")) {
                usage = KeyUsage.NON_REPUDIATION;
            } else if (name.equalsIgnoreCase("keyEncipherment")) {
                usage = KeyUsage.KEY_ENCIPHERMENT;
            } else if (name.equalsIgnoreCase("dataEncipherment")) {
                usage = KeyUsage.DATA_ENCIPHERMENT;
            } else if (name.equalsIgnoreCase("keyAgreement")) {
                usage = KeyUsage.KEY_AGREEMENT;
            } else if (name.equalsIgnoreCase("keyCertSign")) {
                usage = KeyUsage.KEY_CERT_SIGN;
            } else if (name.equalsIgnoreCase("crlSign")) {
                usage = KeyUsage.CRL_SIGN;
            } else if (name.equalsIgnoreCase("encipherOnly")) {
                usage = KeyUsage.ENCIPHER_ONLY;
            } else {
                if (!name.equalsIgnoreCase("decipherOnly")) continue;
                usage = KeyUsage.DECIPHER_ONLY;
            }
            this.requiredSettings.put(usage, isSet);
        }
    }

    @Override
    public boolean matches(X509Certificate c) {
        boolean[] keyUsage = c.getKeyUsage();
        if (keyUsage == null) {
            return this.requiredSettings.isEmpty();
        }
        for (Map.Entry<KeyUsage, Boolean> entry : this.requiredSettings.entrySet()) {
            KeyUsage usage = entry.getKey();
            boolean isSet = entry.getValue();
            boolean match = isSet == keyUsage[usage.getIndex()];
            if (match) continue;
            return false;
        }
        return true;
    }

    @Generated
    public Map<KeyUsage, Boolean> getRequiredSettings() {
        return this.requiredSettings;
    }
}

