/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl.parser;

import de.governikus.csl.tsl.qualifier.KeyUsageCriterion;
import de.governikus.csl.tsl.qualifier.PolicyCriterion;
import de.governikus.csl.tsl.qualifier.Qualifier;
import de.governikus.csl.tsl.qualifier.QualifierCriterion;
import de.governikus.csl.tsl.uris.ServiceQualifier;
import java.util.ArrayList;
import java.util.List;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.CriteriaListType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.KeyUsageType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.PoliciesListType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.QualificationElementType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.QualificationsType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.QualifierType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.QualifiersType;

public class QualificationParser {
    public List<Qualifier> parse(QualificationsType qualifications) {
        ArrayList<Qualifier> result = new ArrayList<Qualifier>();
        List qualificationElements = qualifications.getQualificationElement();
        for (QualificationElementType qualificationElement : qualificationElements) {
            CriteriaListType criteriaList = qualificationElement.getCriteriaList();
            QualifiersType qualifiers = qualificationElement.getQualifiers();
            List<QualifierCriterion> criteria = this.parseCriteria(criteriaList);
            String assertion = null;
            if (criteriaList != null) {
                assertion = criteriaList.getAssert();
            }
            List<ServiceQualifier> qualifierUris = this.parseQualifiers(qualifiers);
            Qualifier q = new Qualifier(qualifierUris, criteria, assertion);
            result.add(q);
        }
        return result;
    }

    private List<ServiceQualifier> parseQualifiers(QualifiersType qualifiers) {
        List qualifierList = qualifiers.getQualifier();
        ArrayList<ServiceQualifier> result = new ArrayList<ServiceQualifier>();
        for (QualifierType qualifier : qualifierList) {
            result.add(ServiceQualifier.wrap((String)qualifier.getUri()));
        }
        return result;
    }

    private List<QualifierCriterion> parseCriteria(CriteriaListType criteriaList) {
        List policySet;
        ArrayList<QualifierCriterion> result = new ArrayList<QualifierCriterion>();
        if (criteriaList == null) {
            return result;
        }
        List keyUsages = criteriaList.getKeyUsage();
        if (keyUsages != null) {
            for (KeyUsageType keyUsage : keyUsages) {
                KeyUsageCriterion crit = new KeyUsageCriterion(keyUsage);
                result.add(crit);
            }
        }
        if ((policySet = criteriaList.getPolicySet()) != null) {
            for (PoliciesListType policy : policySet) {
                PolicyCriterion pc = new PolicyCriterion(policy);
                result.add(pc);
            }
        }
        return result;
    }
}

