/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl.filter;

import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.Predicate;

public class FilterServicesByIssuer
implements Predicate<ServiceInformation> {
    private X509CertificateBaseFacade<?> cert;

    public FilterServicesByIssuer(X509CertificateBaseFacade<?> cert) {
        this.cert = cert;
    }

    @Override
    public boolean test(ServiceInformation t) {
        X509Certificate certificate = t.getCertificate();
        try {
            this.cert.verify(certificate.getPublicKey(), "BC");
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException generalSecurityException) {
            return false;
        }
    }
}

