/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl;

import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.TLInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._119612._02231.v2_.AdditionalInformationType;
import org.etsi.uri._119612._02231.v2_.AnyType;
import org.etsi.uri._119612._02231.v2_.DigitalIdentityListType;
import org.etsi.uri._119612._02231.v2_.DigitalIdentityType;
import org.etsi.uri._119612._02231.v2_.InternationalNamesType;
import org.etsi.uri._119612._02231.v2_.MultiLangNormStringType;
import org.etsi.uri._119612._02231.v2_.NextUpdateType;
import org.etsi.uri._119612._02231.v2_.OtherTSLPointerType;
import org.etsi.uri._119612._02231.v2_.ServiceDigitalIdentityListType;
import org.etsi.uri._119612._02231.v2_.TSLSchemeInformationType;
import org.etsi.uri._119612._02231.v2_.TrustStatusListType;

public class TLUtil {
    public static String getSchemeTerritory(OtherTSLPointerType tslPointer) {
        AdditionalInformationType additionalInformation = tslPointer.getAdditionalInformation();
        List textualInformationOrOtherInformation = additionalInformation.getTextualInformationOrOtherInformation();
        if (textualInformationOrOtherInformation != null) {
            for (Object o : textualInformationOrOtherInformation) {
                if (!(o instanceof AnyType)) continue;
                AnyType at = (AnyType)o;
                List content = at.getContent();
                for (Object o2 : content) {
                    JAXBElement elem;
                    if (!(o2 instanceof JAXBElement) || !(elem = (JAXBElement)o2).getName().getLocalPart().equals("SchemeTerritory")) continue;
                    return elem.getValue().toString();
                }
            }
        }
        return null;
    }

    public static List<X509Certificate> getCertificates(OtherTSLPointerType tslPointer) throws CertificateException, NoSuchProviderException {
        CertificateFactory cf = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
        ServiceDigitalIdentityListType serviceDigitalIdentities = tslPointer.getServiceDigitalIdentities();
        if (serviceDigitalIdentities == null) {
            return null;
        }
        List serviceDigitalIdentity = serviceDigitalIdentities.getServiceDigitalIdentity();
        ArrayList<X509Certificate> result = null;
        for (DigitalIdentityListType identity : serviceDigitalIdentity) {
            List digitalIds = identity.getDigitalId();
            for (DigitalIdentityType digitalID : digitalIds) {
                byte[] x509Certificate = digitalID.getX509Certificate();
                if (x509Certificate == null) continue;
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(x509Certificate);
                    Throwable throwable = null;
                    try {
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        if (result == null) {
                            result = new ArrayList<X509Certificate>();
                        }
                        result.add(cert);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bais == null) continue;
                        if (throwable != null) {
                            try {
                                bais.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        bais.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static TLInfo createTLIdentifier(TrustStatusListType tl, String url) {
        Date dateTime;
        NextUpdateType nextUpdate;
        Date listIssueDateTime;
        TSLSchemeInformationType schemeInformation = tl.getSchemeInformation();
        TLInfo identifier = new TLInfo();
        identifier.setCountryCode(schemeInformation.getSchemeTerritory());
        identifier.setId(schemeInformation.getTSLSequenceNumber().intValue());
        identifier.setSchemaVersion(schemeInformation.getTSLVersionIdentifier().intValue());
        identifier.setUrl(url);
        InternationalNamesType schemeOperatorName = schemeInformation.getSchemeOperatorName();
        if (schemeOperatorName != null) {
            identifier.setIssuerName(TLUtil.getName(schemeOperatorName, "de", "en"));
        }
        if ((listIssueDateTime = schemeInformation.getListIssueDateTime()) != null) {
            identifier.setIssueDate(listIssueDateTime);
        }
        if ((nextUpdate = schemeInformation.getNextUpdate()) != null && (dateTime = nextUpdate.getDateTime()) != null) {
            identifier.setNextUpdate(dateTime);
        }
        return identifier;
    }

    public static String getName(InternationalNamesType internationalValue, String ... languages) {
        if (internationalValue == null) {
            return null;
        }
        List names = internationalValue.getName();
        if (names == null) {
            return null;
        }
        for (String lang : languages) {
            if (lang == null) continue;
            for (MultiLangNormStringType name : names) {
                String currentLanguage = name.getLang();
                if (currentLanguage == null || !currentLanguage.equals(lang)) continue;
                return name.getValue();
            }
        }
        return null;
    }
}

