/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.TLUtil;
import de.governikus.csl.tsl.TakenOverBy;
import de.governikus.csl.tsl.parser.QualificationParser;
import de.governikus.csl.tsl.qualifier.Qualifier;
import de.governikus.csl.tsl.uris.AdditionalServiceInformation;
import de.governikus.csl.tsl.uris.ServiceStatus;
import de.governikus.csl.tsl.uris.ServiceType;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.validate.ValidityModel;
import de.governikus.csl.utils.ByteArrayKey;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.InternationalizedPostalAddress;
import de.governikus.csl.validate.svp.InternationalizedString;
import de.governikus.csl.validate.svp.TLInfo;
import de.governikus.csl.validate.svp.TSPInfo;
import de.governikus.tslextension.AdditionalCertificateInformation;
import de.governikus.tslextension.AdditionalCertificateInformations;
import de.governikus.tslextension.GovTSLExtension;
import de.governikus.tslextension.PathValidateMethod;
import de.governikus.tslextension.ValMethod;
import de.governikus.tslextension.ValMethodCRL;
import de.governikus.tslextension.ValMethodOCSP;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.JAXBElement;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.etsi.uri._119612._02231.v2.additionaltypes_.TakenOverByType;
import org.etsi.uri._119612._02231.v2_.AdditionalServiceInformationType;
import org.etsi.uri._119612._02231.v2_.AddressType;
import org.etsi.uri._119612._02231.v2_.DigitalIdentityListType;
import org.etsi.uri._119612._02231.v2_.DigitalIdentityType;
import org.etsi.uri._119612._02231.v2_.ElectronicAddressType;
import org.etsi.uri._119612._02231.v2_.ExtensionType;
import org.etsi.uri._119612._02231.v2_.ExtensionsListType;
import org.etsi.uri._119612._02231.v2_.InternationalNamesType;
import org.etsi.uri._119612._02231.v2_.MultiLangNormStringType;
import org.etsi.uri._119612._02231.v2_.NonEmptyMultiLangURIListType;
import org.etsi.uri._119612._02231.v2_.NonEmptyMultiLangURIType;
import org.etsi.uri._119612._02231.v2_.PostalAddressListType;
import org.etsi.uri._119612._02231.v2_.PostalAddressType;
import org.etsi.uri._119612._02231.v2_.ServiceHistoryInstanceType;
import org.etsi.uri._119612._02231.v2_.ServiceHistoryType;
import org.etsi.uri._119612._02231.v2_.TSPInformationType;
import org.etsi.uri._119612._02231.v2_.TSPServiceInformationType;
import org.etsi.uri._119612._02231.v2_.TSPServiceType;
import org.etsi.uri._119612._02231.v2_.TSPServicesListType;
import org.etsi.uri._119612._02231.v2_.TSPType;
import org.etsi.uri._119612._02231.v2_.TrustServiceProviderListType;
import org.etsi.uri._119612._02231.v2_.TrustStatusListType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.QualificationsType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig.KeyValueType;

public class TLPreProcessor {
    protected TLInfo identifier;
    protected TLInfo extensionIdentifier;
    protected String url;
    protected String extensionURL;
    protected Map<String, List<ServiceInformation>> entries = new HashMap<String, List<ServiceInformation>>();
    protected Map<ByteArrayKey, List<ServiceInformation>> entriesByKeyIdentifier = new HashMap<ByteArrayKey, List<ServiceInformation>>();
    private MessageDigest messageDigest;
    private static final Logger LOGGER = LoggerFactory.getLogger(TLPreProcessor.class);

    protected void processTSL(TrustStatusListType managedTSL, GovTSLExtension tslExtension) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.messageDigest = CryptoProviderUtil.getMessageDigestInstance((String)"SHA-1");
        this.identifier = TLUtil.createTLIdentifier(managedTSL, this.url);
        Map<ByteBuffer, AdditionalCertificateInformation> map = null;
        String extensionHashAlgorithm = null;
        MessageDigest messageDigestInstance = null;
        if (tslExtension != null) {
            Date expirationDate;
            Date listIssueDateTime;
            List operatorNames;
            this.extensionIdentifier = new TLInfo();
            this.extensionIdentifier.setCountryCode(tslExtension.getSchemeTerritory());
            this.extensionIdentifier.setId(this.safeParse(tslExtension.getSequenceNumber()));
            this.extensionIdentifier.setUrl(this.extensionURL);
            de.governikus.tslextension.InternationalNamesType schemeOperatorName = tslExtension.getSchemeOperatorName();
            if (schemeOperatorName != null && (operatorNames = schemeOperatorName.getName()).size() > 0) {
                this.extensionIdentifier.setIssuerName(((de.governikus.tslextension.MultiLangNormStringType)operatorNames.get(0)).getValue());
            }
            if ((listIssueDateTime = tslExtension.getIssueDate()) != null) {
                this.extensionIdentifier.setIssueDate(listIssueDateTime);
            }
            if ((expirationDate = tslExtension.getExpirationDate()) != null) {
                this.extensionIdentifier.setNextUpdate(expirationDate);
            }
            AdditionalCertificateInformations additionalCertificateInformations = tslExtension.getAdditionalCertificateInformations();
            map = this.groupTSLExtensionEntries(additionalCertificateInformations.getAdditionalCertificateInformation());
            extensionHashAlgorithm = additionalCertificateInformations.getDigestMethod();
            if (extensionHashAlgorithm == null) {
                LOGGER.error("No digest algorithm given in TL extension. Using default Algorithm: SHA-256");
                extensionHashAlgorithm = "SHA-256";
            }
            messageDigestInstance = CryptoProviderUtil.getMessageDigestInstance((String)extensionHashAlgorithm);
        }
        CertificateFactory factory = null;
        try {
            factory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
        }
        catch (CertificateException e) {
            LogHelper.fatal((String)"Can`t istantiate CertificateFactory.", (Exception)e, (Logger)LOGGER);
            return;
        }
        TrustServiceProviderListType trustServiceProviderList = managedTSL.getTrustServiceProviderList();
        if (trustServiceProviderList == null) {
            LOGGER.warn("No TrustServiceProviderList found for TSL.");
            return;
        }
        for (TSPType tsp : trustServiceProviderList.getTrustServiceProvider()) {
            TSPInformationType tspInformation = tsp.getTSPInformation();
            TSPInfo serviceProviderInfo = this.processTSPInformation(tspInformation);
            TSPServicesListType tspServices = tsp.getTSPServices();
            for (TSPServiceType tspst : tspServices.getTSPService()) {
                TSPServiceInformationType serviceInformation = tspst.getServiceInformation();
                List<X509Certificate> certificates = this.processServiceInformation(serviceInformation, factory, tslExtension, messageDigestInstance, map, serviceProviderInfo);
                ServiceHistoryType serviceHistory = tspst.getServiceHistory();
                if (serviceHistory == null) continue;
                for (ServiceHistoryInstanceType hist : serviceHistory.getServiceHistoryInstance()) {
                    this.processHistoricServiceInformation(hist, factory, tslExtension, messageDigestInstance, map, certificates, serviceProviderInfo);
                }
            }
        }
    }

    private TSPInfo processTSPInformation(TSPInformationType tspInformation) {
        AddressType tspAddress;
        List names;
        InternationalNamesType tspTradeName;
        List names2;
        InternationalNamesType tspName;
        List informationUris;
        TSPInfo result = new TSPInfo();
        NonEmptyMultiLangURIListType tspInformationURI = tspInformation.getTSPInformationURI();
        if (tspInformationURI != null && (informationUris = tspInformationURI.getURI()) != null && !informationUris.isEmpty()) {
            List data = result.getTspInformationURIs();
            for (NonEmptyMultiLangURIType uri : informationUris) {
                InternationalizedString is = new InternationalizedString();
                is.setLang(uri.getLang());
                is.setValue(uri.getValue());
                data.add(is);
            }
        }
        if ((tspName = tspInformation.getTSPName()) != null && (names2 = tspName.getName()) != null && !names2.isEmpty()) {
            List data = result.getNames();
            for (MultiLangNormStringType name : names2) {
                this.processMultiLangNormString(data, name);
            }
        }
        if ((tspTradeName = tspInformation.getTSPTradeName()) != null && (names = tspTradeName.getName()) != null && !names.isEmpty()) {
            List data = result.getTradeNames();
            for (MultiLangNormStringType name : names) {
                this.processMultiLangNormString(data, name);
            }
        }
        if ((tspAddress = tspInformation.getTSPAddress()) != null) {
            PostalAddressListType pa;
            List postalAddresses;
            List electronicAddresses;
            ElectronicAddressType electronicAddress = tspAddress.getElectronicAddress();
            if (electronicAddress != null && (electronicAddresses = electronicAddress.getURI()) != null && !electronicAddresses.isEmpty()) {
                List data = result.getElectronicAddresses();
                for (NonEmptyMultiLangURIType uri : electronicAddresses) {
                    InternationalizedString is = new InternationalizedString();
                    is.setLang(uri.getLang());
                    is.setValue(uri.getValue());
                    data.add(is);
                }
            }
            if ((postalAddresses = (pa = tspAddress.getPostalAddresses()).getPostalAddress()) != null && !postalAddresses.isEmpty()) {
                List addresses = result.getPostalAddresses();
                for (PostalAddressType pat : postalAddresses) {
                    InternationalizedPostalAddress data = new InternationalizedPostalAddress();
                    data.setCountryName(pat.getCountryName());
                    data.setLang(pat.getLang());
                    data.setLocality(pat.getLocality());
                    data.setPostalCode(pat.getPostalCode());
                    data.setStateOrProvince(pat.getStateOrProvince());
                    data.setStreetAddress(pat.getStreetAddress());
                    addresses.add(data);
                }
            }
        }
        return result;
    }

    private void processHistoricServiceInformation(ServiceHistoryInstanceType hist, CertificateFactory factory, GovTSLExtension tslExtension, MessageDigest messageDigestInstance, Map<ByteBuffer, AdditionalCertificateInformation> map, List<X509Certificate> certificates, TSPInfo serviceProviderInfo) {
        String serviceTypeIdentifier = hist.getServiceTypeIdentifier().trim();
        ExtensionsListType serviceInformationExtensions = hist.getServiceInformationExtensions();
        List<Qualifier> parsedQualifications = this.parseQualifications(serviceInformationExtensions);
        TakenOverBy takenOverBy = this.checkTakenOverBy(serviceInformationExtensions);
        Date expiredCertsRevocationInfo = this.checkExpiredCertsRevocationInfo(serviceInformationExtensions);
        List<AdditionalServiceInformation> parseAdditionalServiceInformation = this.parseAdditionalServiceInformation(serviceInformationExtensions);
        DigitalIdentityListType serviceDigitalIdentity = hist.getServiceDigitalIdentity();
        if (serviceDigitalIdentity == null) {
            LOGGER.info("Missing digitial identity of service in historical data. This entry will be ignored");
            return;
        }
        List digitalId = serviceDigitalIdentity.getDigitalId();
        boolean certFound = false;
        HashSet<X509Certificate> justParsedCertificates = new HashSet<X509Certificate>();
        for (DigitalIdentityType id : digitalId) {
            X509Certificate certificate = null;
            byte[] x509Certificate = id.getX509Certificate();
            byte[] x509ski = id.getX509SKI();
            String x509SubjectName = id.getX509SubjectName();
            KeyValueType keyValue = id.getKeyValue();
            if (x509Certificate != null) {
                try (ByteArrayInputStream bais = new ByteArrayInputStream(x509Certificate);){
                    certificate = (X509Certificate)factory.generateCertificate(bais);
                }
                catch (IOException | CertificateException e) {
                    LOGGER.warn("Failed to process certificate.", (Throwable)e);
                }
            } else if (x509ski != null) {
                certificate = this.findCertBySubjectKeyIdentifier(certificates, x509ski);
            } else if (x509SubjectName != null && !x509SubjectName.isEmpty()) {
                certificate = this.findCertBySubjectName(certificates, x509SubjectName);
            } else if (keyValue != null) {
                // empty if block
            }
            if (certificate == null || justParsedCertificates.contains(certificate)) continue;
            if (x509Certificate == null) {
                try {
                    x509Certificate = certificate.getEncoded();
                }
                catch (CertificateEncodingException e) {
                    LogHelper.logException(null, (Logger)LOGGER, (Throwable)e);
                }
            }
            justParsedCertificates.add(certificate);
            certFound = true;
            ServiceInformation entry = new ServiceInformation(certificate);
            Date statusStartingTime = hist.getStatusStartingTime();
            if (statusStartingTime != null) {
                entry.setValidFrom(statusStartingTime);
            }
            entry.setServiceTypeIdentifier(ServiceType.wrap((String)serviceTypeIdentifier));
            entry.setServiceStatus(ServiceStatus.wrap((String)hist.getServiceStatus().trim()));
            entry.setServiceQualifier(parsedQualifications);
            entry.setTspInformation(serviceProviderInfo);
            entry.setTakenOverBy(takenOverBy);
            entry.setExpiredCertsRevocationInfo(expiredCertsRevocationInfo);
            entry.setAddtionalServiceInformationURIs(parseAdditionalServiceInformation);
            if (tslExtension != null) {
                byte[] digest = messageDigestInstance.digest(x509Certificate);
                AdditionalCertificateInformation additionalCertificateInformation = map.get(ByteBuffer.wrap(digest));
                this.extendServiceInformationByTSLExtension(entry, additionalCertificateInformation);
            }
            this.addEntry(entry, certificate);
        }
        if (!certFound) {
            LOGGER.warn("No certificate found for service.");
        }
    }

    private X509Certificate findCertBySubjectKeyIdentifier(List<X509Certificate> certificates, byte[] x509ski) {
        for (X509Certificate c : certificates) {
            byte[] extensionValue = c.getExtensionValue("2.5.29.14");
            if (extensionValue != null) {
                ASN1OctetString octetString = ASN1OctetString.getInstance((Object)extensionValue);
                byte[] octets = octetString.getOctets();
                octetString = ASN1OctetString.getInstance((Object)octets);
                boolean equals = Arrays.equals(x509ski, octets = octetString.getOctets());
                if (!equals) continue;
                return c;
            }
            byte[] encoded = c.getPublicKey().getEncoded();
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)encoded);
            ASN1Encodable objectAt = sequence.getObjectAt(1);
            ASN1BitString bs = (ASN1BitString)objectAt;
            byte[] digest = this.messageDigest.digest(encoded = bs.getBytes());
            boolean equals = Arrays.equals(x509ski, digest);
            if (equals) {
                return c;
            }
            byte b = encoded[0];
            b = (byte)(b & 0xFFFFFF7F);
            b = (byte)(b & 0xFF | 0x40);
            b = (byte)(b & 0xFFFFFFDF);
            encoded[0] = b = (byte)(b & 0xFFFFFFEF);
            digest = this.messageDigest.digest(encoded);
            equals = Arrays.equals(x509ski, digest);
            if (!equals) continue;
            return c;
        }
        return null;
    }

    private X509Certificate findCertBySubjectName(List<X509Certificate> certificates, String x509SubjectName) {
        for (X509Certificate c : certificates) {
            X500Principal subjectX500Principal = c.getSubjectX500Principal();
            String name = subjectX500Principal.getName("RFC2253");
            String name2 = subjectX500Principal.getName("RFC1779");
            if (!name.equals(x509SubjectName) && !name2.equals(x509SubjectName)) continue;
            return c;
        }
        return null;
    }

    private void addEntry(ServiceInformation entry, X509Certificate certificate) {
        X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
        String name = this.getIdentifier(subjectX500Principal);
        List<ServiceInformation> managedEntries = this.entries.get(name);
        if (managedEntries == null) {
            managedEntries = new ArrayList<ServiceInformation>();
            this.entries.put(name, managedEntries);
        }
        managedEntries.add(entry);
        byte[] subjectKeyIdentifier = this.getSubjectKeyIdentifierBytes(certificate);
        if (subjectKeyIdentifier != null) {
            ByteArrayKey bak = new ByteArrayKey(subjectKeyIdentifier);
            managedEntries = this.entriesByKeyIdentifier.get(bak);
            if (managedEntries == null) {
                managedEntries = new ArrayList<ServiceInformation>();
                this.entriesByKeyIdentifier.put(bak, managedEntries);
            }
            managedEntries.add(entry);
        }
    }

    private List<X509Certificate> processServiceInformation(TSPServiceInformationType serviceInformation, CertificateFactory factory, GovTSLExtension tslExtension, MessageDigest messageDigestInstance, Map<ByteBuffer, AdditionalCertificateInformation> map, TSPInfo serviceProviderInfo) {
        String serviceTypeIdentifier = serviceInformation.getServiceTypeIdentifier().trim();
        ExtensionsListType serviceInformationExtensions = serviceInformation.getServiceInformationExtensions();
        List<Qualifier> parsedQualifications = this.parseQualifications(serviceInformationExtensions);
        TakenOverBy takenOverBy = this.checkTakenOverBy(serviceInformationExtensions);
        Date expiredCertsRevocationInfo = this.checkExpiredCertsRevocationInfo(serviceInformationExtensions);
        List<AdditionalServiceInformation> parseAdditionalServiceInformation = this.parseAdditionalServiceInformation(serviceInformationExtensions);
        DigitalIdentityListType serviceDigitalIdentity = serviceInformation.getServiceDigitalIdentity();
        List digitalId = serviceDigitalIdentity.getDigitalId();
        boolean certFound = false;
        ArrayList<X509Certificate> result = null;
        for (DigitalIdentityType id : digitalId) {
            byte[] x509Certificate = id.getX509Certificate();
            if (x509Certificate == null) continue;
            if (result == null) {
                result = new ArrayList<X509Certificate>();
            }
            certFound = true;
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(x509Certificate);
                Throwable throwable = null;
                try {
                    X509Certificate certificate = (X509Certificate)factory.generateCertificate(bais);
                    ServiceInformation entry = new ServiceInformation(certificate);
                    Date statusStartingTime = serviceInformation.getStatusStartingTime();
                    if (statusStartingTime != null) {
                        entry.setValidFrom(statusStartingTime);
                    }
                    entry.setServiceTypeIdentifier(ServiceType.wrap((String)serviceTypeIdentifier));
                    entry.setServiceQualifier(parsedQualifications);
                    entry.setServiceStatus(ServiceStatus.wrap((String)serviceInformation.getServiceStatus().trim()));
                    entry.setTspInformation(serviceProviderInfo);
                    entry.setTakenOverBy(takenOverBy);
                    entry.setAddtionalServiceInformationURIs(parseAdditionalServiceInformation);
                    entry.setExpiredCertsRevocationInfo(expiredCertsRevocationInfo);
                    if (tslExtension != null) {
                        byte[] digest = messageDigestInstance.digest(x509Certificate);
                        AdditionalCertificateInformation additionalCertificateInformation = map.get(ByteBuffer.wrap(digest));
                        this.extendServiceInformationByTSLExtension(entry, additionalCertificateInformation);
                    }
                    this.addEntry(entry, certificate);
                    result.add(certificate);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bais == null) continue;
                    if (throwable != null) {
                        try {
                            bais.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bais.close();
                }
            }
            catch (IOException | CertificateException e) {
                LOGGER.warn("Failed to process certificate.", (Throwable)e);
            }
        }
        if (!certFound) {
            LOGGER.warn("No certificate found for service.");
        }
        return result;
    }

    private int safeParse(String possibleString) {
        if (possibleString == null) {
            return 0;
        }
        try {
            return Integer.parseInt(possibleString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void extendServiceInformationByTSLExtension(ServiceInformation entry, AdditionalCertificateInformation additionalCertificateInformation) {
        ValMethod valMethod;
        if (additionalCertificateInformation == null) {
            return;
        }
        PathValidateMethod pathValidateMethod = additionalCertificateInformation.getPathValidateMethod();
        if (pathValidateMethod != null) {
            ValidityModel model = null;
            switch (pathValidateMethod) {
                case CHAIN: {
                    model = ValidityModel.CHAIN;
                    break;
                }
                case ESCAPE_ROUTE: {
                    model = ValidityModel.ESCAPE_ROUTE;
                    break;
                }
                case HYBRID: {
                    model = ValidityModel.HYBRID;
                    break;
                }
                case SHELL: {
                    model = ValidityModel.SHELL;
                }
            }
            entry.setValidityModel(model);
        }
        if ((valMethod = additionalCertificateInformation.getValMethod()) != null) {
            ValMethodCRL valMethodCRL = valMethod.getValMethodCRL();
            entry.setValMethodCRL(valMethodCRL);
            ValMethodOCSP valMethodOCSP = valMethod.getValMethodOCSP();
            entry.setValMethodOCSP(valMethodOCSP);
        }
    }

    private Map<ByteBuffer, AdditionalCertificateInformation> groupTSLExtensionEntries(List<AdditionalCertificateInformation> list) {
        if (list == null) {
            return null;
        }
        HashMap<ByteBuffer, AdditionalCertificateInformation> result = new HashMap<ByteBuffer, AdditionalCertificateInformation>();
        for (AdditionalCertificateInformation aci : list) {
            result.put(ByteBuffer.wrap(aci.getTSPServiceDigest()), aci);
        }
        return result;
    }

    private List<Qualifier> parseQualifications(ExtensionsListType serviceInformationExtensions) {
        if (serviceInformationExtensions == null) {
            return null;
        }
        QualificationParser qualificationParser = new QualificationParser();
        List extensions = serviceInformationExtensions.getExtension();
        ArrayList<Qualifier> result = null;
        for (ExtensionType extension : extensions) {
            List content = extension.getContent();
            if (content == null) continue;
            for (Object o : content) {
                QualificationsType qualifications;
                List<Qualifier> parsedQualifications;
                if (o instanceof JAXBElement) {
                    JAXBElement elem = (JAXBElement)o;
                    o = elem.getValue();
                }
                if (!(o instanceof QualificationsType) || (parsedQualifications = qualificationParser.parse(qualifications = (QualificationsType)o)) == null) continue;
                if (result == null) {
                    result = new ArrayList<Qualifier>();
                }
                result.addAll(parsedQualifications);
            }
        }
        return result;
    }

    private List<AdditionalServiceInformation> parseAdditionalServiceInformation(ExtensionsListType serviceInformationExtensions) {
        if (serviceInformationExtensions == null) {
            return null;
        }
        List extensions = serviceInformationExtensions.getExtension();
        ArrayList<AdditionalServiceInformation> result = null;
        for (ExtensionType extension : extensions) {
            List content = extension.getContent();
            if (content == null) continue;
            for (Object o : content) {
                String value;
                AdditionalServiceInformationType asit;
                NonEmptyMultiLangURIType uri;
                if (o instanceof JAXBElement) {
                    JAXBElement elem = (JAXBElement)o;
                    o = elem.getValue();
                }
                if (!(o instanceof AdditionalServiceInformationType) || (uri = (asit = (AdditionalServiceInformationType)o).getURI()) == null || (value = uri.getValue()) == null || value.isEmpty()) continue;
                if (result == null) {
                    result = new ArrayList<AdditionalServiceInformation>();
                }
                result.add(AdditionalServiceInformation.wrap((String)value.trim()));
            }
        }
        return result;
    }

    private Date checkExpiredCertsRevocationInfo(ExtensionsListType serviceInformationExtensions) {
        if (serviceInformationExtensions == null) {
            return null;
        }
        Date result = null;
        for (ExtensionType ext : serviceInformationExtensions.getExtension()) {
            List content = ext.getContent();
            if (content == null) continue;
            for (Object o : content) {
                JAXBElement elem;
                if (!(o instanceof JAXBElement) || !"ExpiredCertsRevocationInfo".equals((elem = (JAXBElement)o).getName().getLocalPart()) || !((o = elem.getValue()) instanceof Date)) continue;
                result = (Date)o;
            }
        }
        return result;
    }

    private TakenOverBy checkTakenOverBy(ExtensionsListType serviceInformationExtensions) {
        if (serviceInformationExtensions == null) {
            return null;
        }
        TakenOverBy result = null;
        for (ExtensionType ext : serviceInformationExtensions.getExtension()) {
            List content = ext.getContent();
            if (content == null) continue;
            for (Object o : content) {
                if (o instanceof JAXBElement) {
                    JAXBElement elem = (JAXBElement)o;
                    o = elem.getValue();
                }
                if (!(o instanceof TakenOverByType)) continue;
                TakenOverByType tobt = (TakenOverByType)o;
                result = new TakenOverBy();
                if (tobt.getSchemeOperatorName() != null) {
                    ArrayList<InternationalizedString> schemeOperatorName = new ArrayList<InternationalizedString>();
                    tobt.getSchemeOperatorName().getName().forEach(n -> this.processMultiLangNormString((List<InternationalizedString>)schemeOperatorName, (MultiLangNormStringType)n));
                    result.setSchemeOperatorName(schemeOperatorName);
                }
                if (tobt.getSchemeTerritory() != null) {
                    result.setSchemeTerritory(tobt.getSchemeTerritory());
                }
                if (tobt.getTSPName() == null) continue;
                ArrayList<InternationalizedString> tspName = new ArrayList<InternationalizedString>();
                tobt.getTSPName().getName().forEach(n -> this.processMultiLangNormString((List<InternationalizedString>)tspName, (MultiLangNormStringType)n));
                result.setTspName(tspName);
            }
        }
        return result;
    }

    private void processMultiLangNormString(List<InternationalizedString> list, MultiLangNormStringType mlnst) {
        InternationalizedString internationalizedString = new InternationalizedString();
        internationalizedString.setLang(mlnst.getLang());
        internationalizedString.setValue(mlnst.getValue());
        list.add(internationalizedString);
    }

    protected String getIdentifier(X500Principal principal) {
        return principal.getName("RFC2253");
    }

    protected AuthorityKeyIdentifier getAuthorityKeyIdentifier(X509Extension cert) {
        byte[] extensionValue = cert.getExtensionValue("2.5.29.35");
        if (extensionValue != null) {
            try {
                OCTETSTRING o = new OCTETSTRING(Run.create((Source)new BSource(extensionValue)));
                extensionValue = o.getOctets();
            }
            catch (ParseException e) {
                LOGGER.debug("CRLDistPoint is not encoded in octet string");
            }
            try {
                return AuthorityKeyIdentifier.getInstance((Object)extensionValue);
            }
            catch (Exception e) {
                LOGGER.debug("Can't parse authority key identifier extension", (Throwable)e);
            }
        }
        return null;
    }

    protected byte[] getSubjectKeyIdentifierBytes(X509Extension cert) {
        SubjectKeyIdentifier subjectKeyIdentifier = this.getSubjectKeyIdentifier(cert);
        return subjectKeyIdentifier != null ? subjectKeyIdentifier.getKeyIdentifier() : null;
    }

    protected SubjectKeyIdentifier getSubjectKeyIdentifier(X509Extension cert) {
        byte[] extensionValue = cert.getExtensionValue("2.5.29.14");
        if (extensionValue != null) {
            try {
                OCTETSTRING o = new OCTETSTRING(Run.create((Source)new BSource(extensionValue)));
                extensionValue = o.getOctets();
            }
            catch (ParseException e) {
                LOGGER.debug("CRLDistPoint is not encoded in octet string");
            }
            try {
                return SubjectKeyIdentifier.getInstance((Object)extensionValue);
            }
            catch (Exception e) {
                LOGGER.debug("Can't parse subject key identifier extension", (Throwable)e);
            }
        }
        return null;
    }

    public TLInfo getIdentifier() {
        return this.identifier;
    }

    public TLInfo getExtensionIdentifier() {
        return this.extensionIdentifier;
    }
}

