/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl;

import de.governikus.csl.tsl.ManagedTL;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TLManagerEntry
implements Iterable<ManagedTL> {
    private static final int INDEX_OFFICIAL_TSL = 0;
    private static final int INDEX_GOVERNIKUS_TSL = 2;
    private static final int INDEX_CUSTOM_TSL = 1;
    private ManagedTL[] tsls = new ManagedTL[3];
    private String countryCode;

    public TLManagerEntry(String country) {
        this.countryCode = country;
    }

    public TLManagerEntry(String countryCode, ManagedTL officalTSL, ManagedTL governikusTSL, ManagedTL customTSL) {
        this.countryCode = countryCode;
        this.setCustomTSL(customTSL);
        this.setGovernikusTSL(governikusTSL);
        this.setOfficalTSL(officalTSL);
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public ManagedTL getOfficalTSL() {
        return this.tsls[0];
    }

    public void setOfficalTSL(ManagedTL officalTSL) {
        this.tsls[0] = officalTSL;
    }

    public ManagedTL getGovernikusTSL() {
        return this.tsls[2];
    }

    public void setGovernikusTSL(ManagedTL governikusTSL) {
        this.tsls[2] = governikusTSL;
    }

    public ManagedTL getCustomTSL() {
        return this.tsls[1];
    }

    public void setCustomTSL(ManagedTL customTSL) {
        this.tsls[1] = customTSL;
    }

    @Override
    public Iterator<ManagedTL> iterator() {
        return new TSLIterator(this);
    }

    private class TSLIterator
    implements Iterator<ManagedTL> {
        int cur = 0;
        private TLManagerEntry entry;

        private TSLIterator(TLManagerEntry entry) {
            this.entry = entry;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.cur; i < 3; ++i) {
                if (this.entry.tsls[i] != null) {
                    return true;
                }
                ++this.cur;
            }
            return false;
        }

        @Override
        public ManagedTL next() {
            int t;
            if ((t = this.cur++) >= this.entry.tsls.length) {
                throw new NoSuchElementException();
            }
            return this.entry.tsls[t];
        }

        @Override
        public void remove() {
            ((TLManagerEntry)this.entry).tsls[this.cur] = null;
            --this.cur;
        }
    }
}

