/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl;

import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.certStore.CertStoreResponse;
import de.governikus.csl.result.LDAPEntry;
import de.governikus.csl.tsl.DuplicateCertificateException;
import de.governikus.csl.tsl.InvalidTLHashHandlingApproach;
import de.governikus.csl.tsl.ManagedTL;
import de.governikus.csl.tsl.NotCoveredByLotlException;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.TLCertStoreResponse;
import de.governikus.csl.tsl.TLExtensionException;
import de.governikus.csl.tsl.TLManagerEntry;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.impl.ResourceDocument;
import de.governikus.csl.uom.impl.URLResourceDocument;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.utils.DefaultLocale;
import de.governikus.csl.utils.TrustStore;
import de.governikus.csl.utils.TrustStoreResponse;
import de.governikus.tslextension.GovTSLExtension;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.etsi.uri._119612._02231.v2_.TSLSchemeInformationType;
import org.etsi.uri._119612._02231.v2_.TrustStatusListType;
import org.etsi.uri._119612.trstsvc.svcinfoext.esigdir_1999_93_ec_trustedlist.__.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLManager
implements CertStore,
TrustStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<String, TLManagerEntry> trustedLists;
    protected Map<String, String> countryCodeMappings;
    protected Unmarshaller tslUnmarshaller;
    protected Unmarshaller tslExtensionUnmarshaller;
    protected InvalidTLHashHandlingApproach tlExtensionMismatchHandlingApproach = InvalidTLHashHandlingApproach.USE_EXTENSION_BUT_INVALIDATE_RESULTS;

    public TLManager() {
        this.trustedLists = new HashMap<String, TLManagerEntry>();
        this.countryCodeMappings = new HashMap<String, String>();
        this.countryCodeMappings.put(this.transformCountryCode("GB"), "UK");
        this.countryCodeMappings.put(this.transformCountryCode("GR"), "EL");
    }

    public TLManager(TLManager toCopy) {
        this.trustedLists = new HashMap<String, TLManagerEntry>();
        this.countryCodeMappings = new HashMap<String, String>(toCopy.countryCodeMappings);
        for (Map.Entry<String, TLManagerEntry> entry : toCopy.trustedLists.entrySet()) {
            String country = entry.getKey();
            TLManagerEntry value = entry.getValue();
            TLManagerEntry copiedEntry = new TLManagerEntry(country, value.getOfficalTSL(), value.getGovernikusTSL(), value.getCustomTSL());
            this.trustedLists.put(country, copiedEntry);
        }
    }

    public ManagedTL addTSL(String file, String url, TLType tslType, String tslExtension, String tslExtensionURL) throws IOException, JAXBException, DuplicateCertificateException, NoSuchAlgorithmException, NoSuchProviderException, NotCoveredByLotlException, TLExtensionException, XMLStreamException {
        ResourceDocument tslDoc = new ResourceDocument(file);
        ResourceDocument tslExtensionDoc = null;
        if (tslExtension != null) {
            tslExtensionDoc = new ResourceDocument(tslExtension);
        }
        return this.addTSL((Document)tslDoc, url, tslType, (Document)tslExtensionDoc, tslExtensionURL);
    }

    public ManagedTL addTSL(URL fileURL, String url, TLType tslType, URL tslExtension, String tslExtensionURL) throws NoSuchAlgorithmException, NoSuchProviderException, JAXBException, DuplicateCertificateException, IOException, NotCoveredByLotlException, TLExtensionException, XMLStreamException {
        URLResourceDocument tslDoc = new URLResourceDocument(fileURL);
        URLResourceDocument tslExtensionDoc = null;
        if (tslExtension != null) {
            tslExtensionDoc = new URLResourceDocument(tslExtension);
        }
        return this.addTSL((Document)tslDoc, url, tslType, (Document)tslExtensionDoc, tslExtensionURL);
    }

    public ManagedTL addTSL(File file, String url, TLType tslType, File tslExtension, String tslExtensionURL) throws IOException, JAXBException, DuplicateCertificateException, NoSuchAlgorithmException, NoSuchProviderException, NotCoveredByLotlException, TLExtensionException, XMLStreamException {
        FileDocumentImpl fileDoc = new FileDocumentImpl(file, file.getName());
        FileDocumentImpl tslExtensionDoc = null;
        if (tslExtension != null) {
            tslExtensionDoc = new FileDocumentImpl(tslExtension, tslExtension.getName());
        }
        return this.addTSL((Document)fileDoc, url, tslType, (Document)tslExtensionDoc, tslExtensionURL);
    }

    public ManagedTL addTSL(Document tslDoc, String url, TLType tslType, Document tslExtensionDoc, String tslExtensionURL) throws JAXBException, DuplicateCertificateException, NoSuchAlgorithmException, NoSuchProviderException, IOException, NotCoveredByLotlException, TLExtensionException, XMLStreamException {
        this.log.info("Parsing TSL");
        TrustStatusListType tsl = null;
        try (InputStream is = tslDoc.getInputStream();){
            tsl = this.parseTSL(is);
        }
        GovTSLExtension tslExtension = null;
        if (tslExtensionDoc != null) {
            try (InputStream is = tslExtensionDoc.getInputStream();){
                tslExtension = this.parseTSLExtension(is);
            }
        }
        return this.addTSL(tsl, url, tslType, tslExtension, tslExtensionURL);
    }

    protected GovTSLExtension parseTSLExtension(InputStream stream) throws JAXBException, XMLStreamException {
        Unmarshaller tslExtensionUnmarshaller = this.getTSLExtensionUnmarshaller();
        if (tslExtensionUnmarshaller == null) {
            this.log.error("Can't add tsl since no unmarshaller for tsl extension is available");
            return null;
        }
        XMLInputFactory xif = XMLInputFactory.newFactory();
        SecurityUtils.protectFactoryAgainstXXE((XMLInputFactory)xif);
        XMLStreamReader xsr = xif.createXMLStreamReader(stream);
        Object unmarshalledObject = tslExtensionUnmarshaller.unmarshal(xsr);
        if (unmarshalledObject != null) {
            if (unmarshalledObject instanceof JAXBElement) {
                JAXBElement elem = (JAXBElement)unmarshalledObject;
                unmarshalledObject = elem.getValue();
            }
            if (unmarshalledObject instanceof GovTSLExtension) {
                return (GovTSLExtension)unmarshalledObject;
            }
            this.log.warn("Unsupported type:" + unmarshalledObject.getClass().getName());
        }
        return null;
    }

    protected TrustStatusListType parseTSL(InputStream stream) throws JAXBException, XMLStreamException {
        Unmarshaller tslUnmarshaller = this.getTSLUnmarshaller();
        if (tslUnmarshaller == null) {
            this.log.error("Can't add tsl since no unmarshaller is available");
            return null;
        }
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(stream);
        Object unmarshalledObject = tslUnmarshaller.unmarshal(xsr);
        if (unmarshalledObject != null) {
            if (unmarshalledObject instanceof JAXBElement) {
                JAXBElement elem = (JAXBElement)unmarshalledObject;
                unmarshalledObject = elem.getValue();
            }
            if (unmarshalledObject instanceof TrustStatusListType) {
                return (TrustStatusListType)unmarshalledObject;
            }
            this.log.warn("Unsupported type:" + unmarshalledObject.getClass().getName());
        }
        return null;
    }

    protected ManagedTL addTSL(TrustStatusListType tsl, String url, TLType tslType, GovTSLExtension tslExtension, String tslExtensionURL) throws DuplicateCertificateException, NoSuchAlgorithmException, NoSuchProviderException, TLExtensionException {
        if (tsl == null) {
            throw new IllegalArgumentException("The trusted list to add is null");
        }
        TSLSchemeInformationType schemeInformation = tsl.getSchemeInformation();
        if (schemeInformation == null) {
            throw new IllegalArgumentException("The provided trusted list doesn't contain scheme information");
        }
        String schemeTerritory = schemeInformation.getSchemeTerritory();
        if (schemeTerritory == null) {
            throw new IllegalArgumentException("The provided trusted list doesn't contain any scheme territory information. This information is required to be a managed tsl.");
        }
        String tlNameWithoutSequenceNumber = tslType + "_TL_" + schemeTerritory;
        String tlName = tlNameWithoutSequenceNumber + "_" + schemeInformation.getTSLSequenceNumber();
        boolean invalidateReasonHashInTLExtension = false;
        if (tslExtension != null) {
            String tlExtensionName = tlNameWithoutSequenceNumber + "_EXTENSION_" + tslExtension.getSequenceNumber();
            if (!this.isExtensionMatchingToTL(tsl, tslExtension)) {
                switch (this.tlExtensionMismatchHandlingApproach) {
                    case IGNORE_EXTENSION: {
                        tslExtension = null;
                        tslExtensionURL = null;
                        this.log.info("Trusted list extension file {} does not match to trusted list from file {}. The extension won't be used", (Object)tslExtensionURL, (Object)url);
                        break;
                    }
                    case THROW_EXCEPTION: {
                        throw new TLExtensionException("The trusted list extension references another trusted list than the provided one.");
                    }
                    case USE_EXTENSION: {
                        break;
                    }
                    case USE_EXTENSION_BUT_INVALIDATE_RESULTS: {
                        invalidateReasonHashInTLExtension = true;
                    }
                }
            }
            if (tslExtensionURL != null) {
                this.log.info("Adding {} and {} to manager", (Object)tlName, (Object)tlExtensionName);
            }
        } else {
            this.log.info("Adding {} to manager", (Object)tlName);
        }
        ManagedTL managedTSL = new ManagedTL(tsl, url, tslType, tslExtension, tslExtensionURL);
        if (invalidateReasonHashInTLExtension) {
            managedTSL.addReliabilityConcern("tl_extension_invalid_ref");
        }
        this.add(managedTSL, this.transformCountryCode(schemeTerritory), tslType);
        return managedTSL;
    }

    protected boolean isExtensionMatchingToTL(TrustStatusListType tsl, GovTSLExtension tslExtension) {
        TSLSchemeInformationType schemeInformation = tsl.getSchemeInformation();
        if (schemeInformation == null) {
            return false;
        }
        String schemeTerritory = schemeInformation.getSchemeTerritory();
        String schemeTerritory2 = tslExtension.getSchemeTerritory();
        return this.isEqual(schemeTerritory, schemeTerritory2);
    }

    private boolean isEqual(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    private void add(ManagedTL managedTSL, String schemeTerritory, TLType tslType) throws DuplicateCertificateException {
        TLManagerEntry list = this.trustedLists.get(schemeTerritory);
        if (list == null) {
            list = new TLManagerEntry(schemeTerritory);
            this.trustedLists.put(schemeTerritory, list);
        } else {
            this.checkForDuplicateEntries(list, managedTSL, tslType);
        }
        switch (tslType) {
            case OFFICIAL: {
                list.setOfficalTSL(managedTSL);
                break;
            }
            case GOVERNIKUS: {
                list.setGovernikusTSL(managedTSL);
                break;
            }
            case CUSTOM: {
                list.setCustomTSL(managedTSL);
            }
        }
    }

    private void checkForDuplicateEntries(TLManagerEntry list, ManagedTL managedTSL, TLType tslType) throws DuplicateCertificateException {
        if (list == null) {
            return;
        }
        TLType otherType = null;
        try {
            if (list.getOfficalTSL() != null && tslType != TLType.OFFICIAL) {
                otherType = TLType.OFFICIAL;
                managedTSL.checkDistinctEntries(list.getOfficalTSL());
            }
            if (list.getGovernikusTSL() != null && tslType != TLType.GOVERNIKUS) {
                otherType = TLType.GOVERNIKUS;
                managedTSL.checkDistinctEntries(list.getGovernikusTSL());
            }
            if (list.getCustomTSL() != null && tslType != TLType.CUSTOM) {
                otherType = TLType.CUSTOM;
                managedTSL.checkDistinctEntries(list.getCustomTSL());
            }
        }
        catch (DuplicateCertificateException e) {
            this.log.warn("TL of type {} contains same certificate (subject='{}' as already existing tl of type {}", new Object[]{tslType, e.getCert().getSubjectX500Principal().toString(), otherType});
        }
    }

    private Unmarshaller getTSLUnmarshaller() {
        if (this.tslUnmarshaller != null) {
            return this.tslUnmarshaller;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(org.etsi.uri._119612._02231.v2_.ObjectFactory.class.getPackage().getName());
            sb.append(":");
            sb.append(org.etsi.uri._119612._02231.v2.additionaltypes_.ObjectFactory.class.getPackage().getName());
            sb.append(":");
            sb.append(ObjectFactory.class.getPackage().getName());
            JAXBContext context = JAXBContext.newInstance((String)sb.toString(), (ClassLoader)TLManager.class.getClassLoader());
            this.tslUnmarshaller = context.createUnmarshaller();
            return this.tslUnmarshaller;
        }
        catch (JAXBException e) {
            LogHelper.fatal((String)"Can't create TSL-Unmarshaller", (Exception)((Object)e), (Logger)this.log);
            return null;
        }
    }

    private Unmarshaller getTSLExtensionUnmarshaller() {
        if (this.tslExtensionUnmarshaller != null) {
            return this.tslExtensionUnmarshaller;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((String)GovTSLExtension.class.getPackage().getName(), (ClassLoader)GovTSLExtension.class.getClassLoader());
            this.tslExtensionUnmarshaller = context.createUnmarshaller();
            return this.tslExtensionUnmarshaller;
        }
        catch (JAXBException e) {
            LogHelper.fatal((String)"Can't create TSL-Unmarshaller", (Exception)((Object)e), (Logger)this.log);
            return null;
        }
    }

    private String transformCountryCode(String cc) {
        return cc.toUpperCase();
    }

    @Override
    public TLCertStoreResponse getSigningCertificates(X509CertificateBaseFacade<?> cert, Date date) {
        X500Principal subjectX500Principal;
        X500Principal issuerX500Principal = cert.getIssuerX500Principal();
        TLManagerEntry managedTrustedLists = this.getManagedTrustedLists(issuerX500Principal, subjectX500Principal = cert.getSubjectX500Principal());
        if (managedTrustedLists == null) {
            this.logMissingCert(subjectX500Principal, issuerX500Principal);
            return null;
        }
        CertStoreResponse bestResponse = null;
        for (ManagedTL managedTrustedList : managedTrustedLists) {
            CertStoreResponse signingCertificatesResponse = managedTrustedList.getSigningCertificates((X509CertificateBaseFacade)cert, date);
            if (signingCertificatesResponse == null) continue;
            List<ServiceInformation> matchingCertificates = ((TLCertStoreResponse)signingCertificatesResponse).getMatchingCertificates();
            if (matchingCertificates != null && !matchingCertificates.isEmpty()) {
                return signingCertificatesResponse;
            }
            if (bestResponse != null) continue;
            bestResponse = signingCertificatesResponse;
        }
        return bestResponse;
    }

    @Override
    public TLCertStoreResponse getSigningCertificates(X509CRL crl) {
        TLManagerEntry managedTrustedLists = this.getManagedTrustedLists(crl.getIssuerX500Principal(), null);
        if (managedTrustedLists == null) {
            this.log.warn("Can't find a trusted list for crl");
            return null;
        }
        TLCertStoreResponse bestResponse = null;
        for (ManagedTL managedTrustedList : managedTrustedLists) {
            TLCertStoreResponse signingCertificates = managedTrustedList.getSigningCertificates(crl);
            if (signingCertificates == null) continue;
            List<ServiceInformation> matchingCertificates = signingCertificates.getMatchingCertificates();
            if (matchingCertificates != null && !matchingCertificates.isEmpty()) {
                return signingCertificates;
            }
            if (bestResponse != null) continue;
            bestResponse = signingCertificates;
        }
        return bestResponse;
    }

    public ServiceInformation getIssuerServiceInformation(X509CertificateBaseFacade<?> cert) {
        X500Principal subjectX500Principal;
        X500Principal issuerX500Principal = cert.getIssuerX500Principal();
        TLManagerEntry managedTrustedLists = this.getManagedTrustedLists(issuerX500Principal, subjectX500Principal = cert.getSubjectX500Principal());
        if (managedTrustedLists == null) {
            this.logMissingCert(subjectX500Principal, issuerX500Principal);
            return null;
        }
        for (ManagedTL managedTrustedList : managedTrustedLists) {
            ServiceInformation serviceInformation = managedTrustedList.getIssuerServiceInformation(cert);
            if (serviceInformation == null) continue;
            return serviceInformation;
        }
        return null;
    }

    public TLManagerEntry getManagedTrustedLists(X500Principal defaultPrincipal, X500Principal fallbackPrincipal) {
        LDAPEntry ldapName = new LDAPEntry(defaultPrincipal);
        String country = ldapName.getCountry();
        if (country == null) {
            if (fallbackPrincipal != null) {
                ldapName = new LDAPEntry(fallbackPrincipal);
                country = ldapName.getCountry();
            }
            if (country == null) {
                this.log.info("Can't determine the country, using default locale!");
                country = DefaultLocale.getDefaultCountry();
            }
        }
        return this.getManagedTrustedLists(country);
    }

    private TLManagerEntry getManagedTrustedLists(String country) {
        String mappedCode;
        TLManagerEntry entry = this.trustedLists.get(country = this.transformCountryCode(country));
        if (entry == null && (mappedCode = this.countryCodeMappings.get(country)) != null) {
            mappedCode = this.transformCountryCode(mappedCode);
            entry = this.trustedLists.get(mappedCode);
        }
        return entry;
    }

    public int getNumberOfManagedCountries() {
        return this.trustedLists.size();
    }

    public int[] getNumberOfManagedTSLs() {
        int[] ctr = new int[]{0, 0, 0};
        for (Map.Entry<String, TLManagerEntry> entry : this.trustedLists.entrySet()) {
            TLManagerEntry value = entry.getValue();
            if (value == null) continue;
            ctr[0] = ctr[0] + (value.getOfficalTSL() != null ? 1 : 0);
            ctr[1] = ctr[1] + (value.getCustomTSL() != null ? 1 : 0);
            ctr[2] = ctr[2] + (value.getGovernikusTSL() != null ? 1 : 0);
        }
        return ctr;
    }

    public ManagedTL getTSL(String countryCode, TLType tslType) {
        TLManagerEntry managedTrustedLists = this.getManagedTrustedLists(countryCode);
        if (managedTrustedLists == null || tslType == null) {
            return null;
        }
        switch (tslType) {
            case OFFICIAL: {
                return managedTrustedLists.getOfficalTSL();
            }
            case GOVERNIKUS: {
                return managedTrustedLists.getGovernikusTSL();
            }
            case CUSTOM: {
                return managedTrustedLists.getCustomTSL();
            }
        }
        return null;
    }

    public void removeTSLs(TLType type) {
        for (Map.Entry<String, TLManagerEntry> entry : this.trustedLists.entrySet()) {
            TLManagerEntry tslEntry = entry.getValue();
            switch (type) {
                case OFFICIAL: {
                    tslEntry.setOfficalTSL(null);
                    break;
                }
                case GOVERNIKUS: {
                    tslEntry.setGovernikusTSL(null);
                    break;
                }
                case CUSTOM: {
                    tslEntry.setCustomTSL(null);
                }
            }
        }
    }

    @Override
    public TLCertStoreResponse getCertificates(X500Principal subject) {
        TLManagerEntry managedTrustedLists = this.getManagedTrustedLists(subject, null);
        if (managedTrustedLists == null) {
            this.logMissingCert(subject);
            return null;
        }
        for (ManagedTL managedTrustedList : managedTrustedLists) {
            TLCertStoreResponse signingCertificates = managedTrustedList.getCertificates(subject);
            if (signingCertificates == null || signingCertificates.getMatchingCertificates().isEmpty()) continue;
            return signingCertificates;
        }
        return null;
    }

    @Override
    public TrustStoreResponse getCertificateInformation(X509CertificateBaseFacade<?> certificate, Date serviceStatusDate) {
        X500Principal issuerX500Principal;
        X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
        TLManagerEntry managedTrustedLists = this.getManagedTrustedLists(subjectX500Principal, issuerX500Principal = certificate.getIssuerX500Principal());
        if (managedTrustedLists == null) {
            this.logMissingCert(subjectX500Principal, issuerX500Principal);
            return null;
        }
        for (ManagedTL managedTrustedList : managedTrustedLists) {
            TrustStoreResponse certificateInformation = managedTrustedList.getCertificateInformation(certificate, serviceStatusDate);
            if (certificateInformation == null) continue;
            return certificateInformation;
        }
        return null;
    }

    private void logMissingCert(X500Principal subject) {
        this.logMissingCert(subject, null);
    }

    private void logMissingCert(X500Principal subject, X500Principal issuer) {
        if (subject != null && issuer != null) {
            this.log.warn("Can't find a trusted list for certificate '{}', with issuer '{}'", (Object)subject, (Object)issuer);
        } else if (subject != null) {
            this.log.warn("Can't find a trusted list for certificate '{}'. No issuer principal available.", (Object)subject);
        } else {
            this.log.warn("Can't find a trusted list for certificate. Neither subject nor issuer principal available.");
        }
    }

    public InvalidTLHashHandlingApproach getTlExtensionMismatchHandlingApproach() {
        return this.tlExtensionMismatchHandlingApproach;
    }

    public void setTlExtensionMismatchHandlingApproach(InvalidTLHashHandlingApproach tlExtensionMismatchHandlingApproach) {
        this.tlExtensionMismatchHandlingApproach = tlExtensionMismatchHandlingApproach;
    }

    public List<ManagedTL> getManagedTLs() {
        ArrayList<ManagedTL> result = new ArrayList<ManagedTL>();
        for (Map.Entry<String, TLManagerEntry> entry : this.trustedLists.entrySet()) {
            TLManagerEntry tlEntry = entry.getValue();
            ManagedTL tl = tlEntry.getOfficalTSL();
            if (tl != null) {
                result.add(tl);
            }
            if ((tl = tlEntry.getGovernikusTSL()) != null) {
                result.add(tl);
            }
            if ((tl = tlEntry.getCustomTSL()) == null) continue;
            result.add(tl);
        }
        return result;
    }
}

