/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl;

import de.governikus.csl.certStore.CertStoreResponse;
import de.governikus.csl.simple.xml.EnvelopedXMLSignatureValidationResult;
import de.governikus.csl.simple.xml.EnvelopedXMLSignatureValidator;
import de.governikus.csl.tsl.DuplicateCertificateException;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.InvalidTLSignatureHandlingApproach;
import de.governikus.csl.tsl.ManagedTL;
import de.governikus.csl.tsl.NotCoveredByLotlException;
import de.governikus.csl.tsl.TLCertStoreResponse;
import de.governikus.csl.tsl.TLExtensionException;
import de.governikus.csl.tsl.TLManager;
import de.governikus.csl.tsl.TLUtil;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.impl.ResourceDocument;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.utils.TrustStoreResponse;
import de.governikus.csl.validate.svp.TLInfo;
import de.governikus.tslextension.GovTSLExtension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.etsi.uri._119612._02231.v2_.OtherTSLPointerType;
import org.etsi.uri._119612._02231.v2_.OtherTSLPointersType;
import org.etsi.uri._119612._02231.v2_.TrustStatusListType;

public class SecureTLManager
extends TLManager
implements Cloneable {
    private static final String UNKNOWN_SCHEME_TERRITORY = "UNKNOWN_SCHEME_TERRITORY";
    private Map<String, List<X509Certificate>> certsInLotl;
    private List<X509Certificate> governikusTLIssuers;
    private List<X509Certificate> customTLIssuers;
    private List<X509Certificate> officialTLExtensionIssuers;
    private List<X509Certificate> governikusTLExtensionIssuers;
    private List<X509Certificate> customTLExtensionIssuers;
    private List<X509Certificate> lotlIssuers;
    private InvalidTLSignatureHandlingApproach invalidOfficialTLSignatureHandlingApproach = InvalidTLSignatureHandlingApproach.USE_TL_BUT_INVALIDATE_RESULTS;
    private InvalidTLSignatureHandlingApproach invalidLOTLSignatureHandlingApproach = InvalidTLSignatureHandlingApproach.USE_TL_BUT_INVALIDATE_RESULTS;
    private InvalidTLSignatureHandlingApproach invalidGovernikusTLSignatureHandlingApproach = InvalidTLSignatureHandlingApproach.USE_TL_BUT_INVALIDATE_RESULTS;
    private InvalidTLSignatureHandlingApproach invalidCustomTLSignatureHandlingApproach = InvalidTLSignatureHandlingApproach.USE_TL_BUT_INVALIDATE_RESULTS;
    private boolean validLotl = false;
    private TLInfo lotlInfo;

    public SecureTLManager(String lotl) throws IOException, JAXBException, CertificateException, NoSuchProviderException, NotCoveredByLotlException, XMLStreamException {
        this.certsInLotl = new HashMap<String, List<X509Certificate>>();
        if (lotl != null) {
            this.loadLotl((Document)new ResourceDocument(lotl), null);
        }
    }

    public SecureTLManager(String lotl, List<X509Certificate> lotlIssuers) throws IOException, JAXBException, CertificateException, NoSuchProviderException, NotCoveredByLotlException, XMLStreamException {
        this.lotlIssuers = lotlIssuers;
        this.certsInLotl = new HashMap<String, List<X509Certificate>>();
        if (lotl != null) {
            this.loadLotl((Document)new ResourceDocument(lotl), null);
        }
    }

    public SecureTLManager(File lotl) throws IOException, JAXBException, CertificateException, NoSuchProviderException, NotCoveredByLotlException, XMLStreamException {
        this.certsInLotl = new HashMap<String, List<X509Certificate>>();
        if (lotl != null) {
            this.loadLotl((Document)new FileDocumentImpl(lotl, lotl.getName()), null);
        }
    }

    public SecureTLManager(File lotl, List<X509Certificate> lotlIssuers) throws IOException, JAXBException, CertificateException, NoSuchProviderException, NotCoveredByLotlException, XMLStreamException {
        this.lotlIssuers = lotlIssuers;
        this.certsInLotl = new HashMap<String, List<X509Certificate>>();
        if (lotl != null) {
            this.loadLotl((Document)new FileDocumentImpl(lotl, lotl.getName()), null);
        }
    }

    public SecureTLManager(Document lotl) throws IOException, CertificateException, NoSuchProviderException, JAXBException, NotCoveredByLotlException, XMLStreamException {
        this.certsInLotl = new HashMap<String, List<X509Certificate>>();
        if (lotl != null) {
            this.loadLotl(lotl, null);
        }
    }

    public SecureTLManager(Document lotl, String lotlURL, List<X509Certificate> lotlIssuers) throws IOException, CertificateException, NoSuchProviderException, JAXBException, NotCoveredByLotlException, XMLStreamException {
        this.lotlIssuers = lotlIssuers;
        this.certsInLotl = new HashMap<String, List<X509Certificate>>();
        if (lotl != null) {
            this.loadLotl(lotl, lotlURL);
        }
    }

    public SecureTLManager() {
        this.certsInLotl = new HashMap<String, List<X509Certificate>>();
    }

    public SecureTLManager(SecureTLManager toCopy) {
        super(toCopy);
        this.certsInLotl = new HashMap<String, List<X509Certificate>>(toCopy.certsInLotl);
        this.lotlIssuers = toCopy.lotlIssuers;
    }

    private void loadLotl(Document lotl, String lotlURL) throws IOException, CertificateException, NoSuchProviderException, JAXBException, NotCoveredByLotlException, XMLStreamException {
        boolean validLOTL = this.validateLOTL(lotl);
        this.validLotl = !validLOTL ? !this.process(this.invalidLOTLSignatureHandlingApproach) : true;
        try (InputStream stream = lotl.getInputStream();){
            this.parseLotl(stream, lotlURL);
        }
    }

    private boolean validateLOTL(Document lotl) throws IOException {
        try (InputStream is = lotl.getInputStream();){
            boolean bl = this.checkSignature(is, this.lotlIssuers);
            return bl;
        }
    }

    private void parseLotl(InputStream lotl, String lotlURL) throws JAXBException, CertificateException, NoSuchProviderException, XMLStreamException {
        TrustStatusListType parsedLotl = this.parseTSL(lotl);
        if (parsedLotl == null) {
            return;
        }
        this.lotlInfo = TLUtil.createTLIdentifier(parsedLotl, lotlURL);
        OtherTSLPointersType pointersToOtherTL = parsedLotl.getSchemeInformation().getPointersToOtherTSL();
        List otherTLPointer = pointersToOtherTL.getOtherTSLPointer();
        String country = UNKNOWN_SCHEME_TERRITORY;
        for (OtherTSLPointerType tlPointer : otherTLPointer) {
            List<X509Certificate> certs;
            String schemeTerritory = TLUtil.getSchemeTerritory(tlPointer);
            if (schemeTerritory != null) {
                country = schemeTerritory;
            }
            if ((certs = TLUtil.getCertificates(tlPointer)) == null) continue;
            List<X509Certificate> list = this.certsInLotl.get(country);
            if (list == null) {
                this.certsInLotl.put(country, certs);
                continue;
            }
            list.addAll(certs);
        }
    }

    @Override
    public ManagedTL addTSL(Document file, String url, TLType tlType, Document tlExtension, String tlExtensionURL) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, JAXBException, DuplicateCertificateException, TLExtensionException, NotCoveredByLotlException, XMLStreamException {
        TrustStatusListType parsedTL = null;
        try (InputStream is = file.getInputStream();){
            parsedTL = this.parseTSL(is);
        }
        GovTSLExtension parsedTLExtension = null;
        if (tlExtension != null) {
            try (InputStream is = tlExtension.getInputStream();){
                parsedTLExtension = this.parseTSLExtension(is);
            }
        }
        List<X509Certificate> tlIssuers = null;
        List<X509Certificate> tlExtensionIssuers = null;
        InvalidTLSignatureHandlingApproach errorHandlingType = null;
        switch (tlType) {
            case OFFICIAL: {
                String schemeTerritory = parsedTL.getSchemeInformation().getSchemeTerritory();
                tlIssuers = this.certsInLotl.get(schemeTerritory);
                if (tlIssuers == null) {
                    tlIssuers = this.certsInLotl.get(UNKNOWN_SCHEME_TERRITORY);
                }
                errorHandlingType = this.invalidOfficialTLSignatureHandlingApproach;
                tlExtensionIssuers = this.officialTLExtensionIssuers;
                break;
            }
            case GOVERNIKUS: {
                tlIssuers = this.governikusTLIssuers;
                errorHandlingType = this.invalidGovernikusTLSignatureHandlingApproach;
                tlExtensionIssuers = this.governikusTLExtensionIssuers;
                break;
            }
            case CUSTOM: {
                tlIssuers = this.customTLIssuers;
                errorHandlingType = this.invalidCustomTLSignatureHandlingApproach;
                tlExtensionIssuers = this.customTLExtensionIssuers;
            }
        }
        boolean invalidateReasonTL = this.validateSignedFile(file, tlIssuers, errorHandlingType);
        boolean invalidateReasonTLExtension = false;
        if (parsedTLExtension != null) {
            invalidateReasonTLExtension = this.validateSignedFile(tlExtension, tlExtensionIssuers, errorHandlingType);
        }
        ManagedTL managedTL = this.addTSL(parsedTL, url, tlType, parsedTLExtension, tlExtensionURL);
        if (invalidateReasonTL) {
            managedTL.addReliabilityConcern("tl_invalid_signature");
        }
        if (invalidateReasonTLExtension) {
            managedTL.addReliabilityConcern("tl_extension_invalid_signature");
        }
        if (tlType == TLType.OFFICIAL && !this.validLotl) {
            managedTL.addReliabilityConcern("lotl_invalid_signature");
        }
        return managedTL;
    }

    private boolean validateSignedFile(Document file, List<X509Certificate> allowedCertificates, InvalidTLSignatureHandlingApproach errorHandlingType) throws IOException, NotCoveredByLotlException {
        if (allowedCertificates == null) {
            return this.process(errorHandlingType);
        }
        try (InputStream is = file.getInputStream();){
            if (!this.checkSignature(is, allowedCertificates)) {
                boolean bl = this.process(errorHandlingType);
                return bl;
            }
        }
        return false;
    }

    private boolean process(InvalidTLSignatureHandlingApproach errorHandlingType) throws NotCoveredByLotlException {
        switch (errorHandlingType) {
            case THROW_EXCEPTION: {
                throw new NotCoveredByLotlException();
            }
            case USE_TL: {
                break;
            }
            case USE_TL_BUT_INVALIDATE_RESULTS: {
                return true;
            }
        }
        return false;
    }

    private boolean checkSignature(InputStream stream, List<X509Certificate> allowedCertificates) {
        if (allowedCertificates == null) {
            return false;
        }
        EnvelopedXMLSignatureValidator validator = new EnvelopedXMLSignatureValidator(allowedCertificates);
        EnvelopedXMLSignatureValidationResult validateResult = validator.validate(stream);
        return validateResult.isSignatureValid() && validateResult.isWholeDocumentSigned();
    }

    public InvalidTLSignatureHandlingApproach getInvalidOfficialTSLSignatureHandlingApproach() {
        return this.invalidOfficialTLSignatureHandlingApproach;
    }

    public void setInvalidOfficialTSLSignatureHandlingApproach(InvalidTLSignatureHandlingApproach invalidOfficialTSLSignatureHandlingApproach) {
        this.invalidOfficialTLSignatureHandlingApproach = invalidOfficialTSLSignatureHandlingApproach;
    }

    public List<X509Certificate> getGovernikusTSLIssuers() {
        return this.governikusTLIssuers;
    }

    public void setGovernikusTSLIssuers(List<X509Certificate> governikusTSLIssuers) {
        this.governikusTLIssuers = governikusTSLIssuers;
    }

    public List<X509Certificate> getCustomTSLIssuers() {
        return this.customTLIssuers;
    }

    public void setCustomTSLIssuers(List<X509Certificate> customTSLIssuers) {
        this.customTLIssuers = customTSLIssuers;
    }

    public List<X509Certificate> getOfficialTSLExtensionIssuers() {
        return this.officialTLExtensionIssuers;
    }

    public void setOfficialTSLExtensionIssuers(List<X509Certificate> officialTLExtensionIssuers) {
        this.officialTLExtensionIssuers = officialTLExtensionIssuers;
    }

    public List<X509Certificate> getGovernikusTSLExtensionIssuers() {
        return this.governikusTLExtensionIssuers;
    }

    public void setGovernikusTSLExtensionIssuers(List<X509Certificate> governikusTLExtensionIssuers) {
        this.governikusTLExtensionIssuers = governikusTLExtensionIssuers;
    }

    public List<X509Certificate> getCustomTSLExtensionIssuers() {
        return this.customTLExtensionIssuers;
    }

    public void setCustomTSLExtensionIssuers(List<X509Certificate> customTLExtensionIssuers) {
        this.customTLExtensionIssuers = customTLExtensionIssuers;
    }

    public InvalidTLSignatureHandlingApproach getInvalidGovernikusTLSignatureHandlingApproach() {
        return this.invalidGovernikusTLSignatureHandlingApproach;
    }

    public void setInvalidGovernikusTSLSignatureHandlingApproach(InvalidTLSignatureHandlingApproach invalidGovernikusTLSignatureHandlingApproach) {
        this.invalidGovernikusTLSignatureHandlingApproach = invalidGovernikusTLSignatureHandlingApproach;
    }

    public InvalidTLSignatureHandlingApproach getInvalidCustomTSLSignatureHandlingApproach() {
        return this.invalidCustomTLSignatureHandlingApproach;
    }

    public void setInvalidCustomTSLSignatureHandlingApproach(InvalidTLSignatureHandlingApproach invalidCustomTLSignatureHandlingApproach) {
        this.invalidCustomTLSignatureHandlingApproach = invalidCustomTLSignatureHandlingApproach;
    }

    public InvalidTLSignatureHandlingApproach getInvalidLOTLSignatureHandlingApproach() {
        return this.invalidLOTLSignatureHandlingApproach;
    }

    public void setInvalidLOTLSignatureHandlingApproach(InvalidTLSignatureHandlingApproach invalidLOTLSignatureHandlingApproach) {
        this.invalidLOTLSignatureHandlingApproach = invalidLOTLSignatureHandlingApproach;
    }

    @Override
    public TLCertStoreResponse getSigningCertificates(X509CertificateBaseFacade<?> cert, Date date) {
        CertStoreResponse resp = super.getSigningCertificates((X509CertificateBaseFacade)cert, date);
        this.extend((TLCertStoreResponse)resp);
        return resp;
    }

    @Override
    public TLCertStoreResponse getSigningCertificates(X509CRL crl) {
        TLCertStoreResponse resp = super.getSigningCertificates(crl);
        this.extend(resp);
        return resp;
    }

    @Override
    public TLCertStoreResponse getCertificates(X500Principal subject) {
        TLCertStoreResponse resp = super.getCertificates(subject);
        this.extend(resp);
        return resp;
    }

    @Override
    public TrustStoreResponse getCertificateInformation(X509CertificateBaseFacade<?> certificate, Date serviceStatusDate) {
        TrustStoreResponse resp = super.getCertificateInformation(certificate, serviceStatusDate);
        this.extend(resp);
        return resp;
    }

    private void extend(TrustStoreResponse resp) {
        ExtendedTLInformation tlInformation;
        if (resp != null && (tlInformation = resp.getTslInformation()) != null) {
            this.extend(tlInformation);
        }
    }

    private void extend(TLCertStoreResponse resp) {
        ExtendedTLInformation tlInformation;
        if (resp != null && (tlInformation = resp.getTlInformation()) != null) {
            this.extend(tlInformation);
        }
    }

    private void extend(ExtendedTLInformation tlInformation) {
        if (tlInformation.getTslType() != TLType.OFFICIAL) {
            return;
        }
        tlInformation.setLotlInfo(this.lotlInfo);
    }

    public TLInfo getLotlInfo() {
        return this.lotlInfo;
    }

    public boolean isValidLotl() {
        return this.validLotl;
    }
}

