/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.tsl;

import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.certStore.CertificateData;
import de.governikus.csl.tsl.DuplicateCertificateException;
import de.governikus.csl.tsl.ExtendedTLInformation;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.tsl.TLCertStoreResponse;
import de.governikus.csl.tsl.TLPreProcessor;
import de.governikus.csl.tsl.uris.ServiceStatus;
import de.governikus.csl.tsl.uris.ServiceType;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.utils.ByteArrayKey;
import de.governikus.csl.utils.TrustStore;
import de.governikus.csl.utils.TrustStoreResponse;
import de.governikus.tslextension.GovTSLExtension;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.etsi.uri._119612._02231.v2_.TrustStatusListType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedTL
extends TLPreProcessor
implements CertStore,
TrustStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedTL.class);
    private TLType tlType;
    private List<String> reliabilityConcerns;

    public ManagedTL(TrustStatusListType managedTL, String tlURl, TLType tlType, GovTSLExtension tlExtension, String tlExtensionURL) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.entries = new HashMap();
        this.url = tlURl;
        this.extensionURL = tlExtensionURL;
        this.tlType = tlType;
        this.processTSL(managedTL, tlExtension);
    }

    @Override
    public TrustStoreResponse getCertificateInformation(X509CertificateBaseFacade<?> certificate, Date serviceStatusDate) {
        TLCertStoreResponse signingCertificates;
        List<ServiceInformation> matchingCertificates;
        if (certificate instanceof X509CertificateImpl && (matchingCertificates = (signingCertificates = this.getSigningCertificates(certificate.getSubjectX500Principal(), cert -> certificate.getWrappedCertificate().equals(cert), serviceStatusDate, Collections.emptySet())).getMatchingCertificates()) != null && !matchingCertificates.isEmpty()) {
            ServiceInformation certificateInformation = matchingCertificates.get(0);
            TrustStoreResponse resp = new TrustStoreResponse();
            resp.setTslInformation(signingCertificates.getTlInformation());
            resp.setServiceInformation(certificateInformation);
            return resp;
        }
        return null;
    }

    @Override
    public TLCertStoreResponse getSigningCertificates(X509CertificateBaseFacade<?> cert, Date date) {
        Set<ServiceType> preferredServiceTypes;
        List<ServiceInformation> serviceInformation = null;
        if ((serviceInformation = this.findServiceInformationByAuthorityKeyIdentifier(cert, serviceInformation)) == null) {
            serviceInformation = this.findServiceInformationBySubjectKeyIdentifier(cert, serviceInformation);
        }
        if (!(serviceInformation = this.filterServiceInformation(serviceInformation, c -> c.getNotBefore().compareTo(date) * date.compareTo(c.getNotAfter()) >= 0, date, preferredServiceTypes = this.obtainPreferredServiceTypes(cert))).isEmpty()) {
            return this.createResponse(serviceInformation);
        }
        CertValidator validator = certificateToValidate -> {
            try {
                cert.verify(certificateToValidate.getPublicKey(), "BC");
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                return false;
            }
            return true;
        };
        return this.getSigningCertificates(cert.getIssuerX500Principal(), validator, date, preferredServiceTypes);
    }

    @Override
    public TLCertStoreResponse getCertificates(X500Principal name) {
        return this.getSigningCertificates(name, certificateToValidate -> {
            X500Principal subjectX500Principal = certificateToValidate.getSubjectX500Principal();
            return subjectX500Principal.equals(name);
        }, null, Collections.emptySet());
    }

    @Override
    public TLCertStoreResponse getSigningCertificates(X509CRL crl) {
        return this.getSigningCertificates(crl.getIssuerX500Principal(), certificateToValidate -> {
            try {
                crl.verify(certificateToValidate.getPublicKey());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CRLException e) {
                return false;
            }
            return true;
        }, null, Collections.emptySet());
    }

    public ServiceInformation getIssuerServiceInformation(X509CertificateBaseFacade<?> cert) {
        String name = this.getIdentifier(cert.getIssuerX500Principal());
        List lic = (List)this.entries.get(name);
        ArrayList<ServiceInformation> verifiedKeys = new ArrayList<ServiceInformation>();
        if (lic != null) {
            for (ServiceInformation ic : lic) {
                try {
                    cert.verify(ic.getCertificate().getPublicKey());
                    verifiedKeys.add(ic);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                    LOGGER.debug("Exception while verifying PublicKey of {}", (Object)ic.getTspInformation(), (Object)e);
                }
            }
            if (verifiedKeys.isEmpty()) {
                LOGGER.debug("Can't find service information for the given certificate with serialnumber {}", (Object)cert.getSerialNumber());
                return null;
            }
            if (verifiedKeys.size() == 1) {
                return (ServiceInformation)verifiedKeys.get(0);
            }
            Set<ServiceType> preferredServiceTypes = this.obtainPreferredServiceTypes(cert);
            this.filterForBestStiStatus(verifiedKeys, preferredServiceTypes);
            return (ServiceInformation)verifiedKeys.get(0);
        }
        return null;
    }

    private List<ServiceInformation> findServiceInformationBySubjectKeyIdentifier(X509CertificateBaseFacade<?> cert, List<ServiceInformation> serviceInformation) {
        byte[] keyIdentifier;
        SubjectKeyIdentifier subjectKeyIdentifier = this.getSubjectKeyIdentifier((X509Extension)cert);
        if (subjectKeyIdentifier != null && (keyIdentifier = subjectKeyIdentifier.getKeyIdentifier()) != null) {
            ByteArrayKey bak = new ByteArrayKey(keyIdentifier);
            serviceInformation = (List)this.entriesByKeyIdentifier.get(bak);
        }
        return serviceInformation;
    }

    private List<ServiceInformation> findServiceInformationByAuthorityKeyIdentifier(X509CertificateBaseFacade<?> cert, List<ServiceInformation> serviceInformation) {
        byte[] keyIdentifier;
        AuthorityKeyIdentifier authorityKeyIdentifier = this.getAuthorityKeyIdentifier((X509Extension)cert);
        if (authorityKeyIdentifier != null && (keyIdentifier = authorityKeyIdentifier.getKeyIdentifier()) != null) {
            ByteArrayKey bak = new ByteArrayKey(keyIdentifier);
            serviceInformation = (List)this.entriesByKeyIdentifier.get(bak);
        }
        return serviceInformation;
    }

    private List<ServiceInformation> filterServiceInformation(List<ServiceInformation> serviceInformation, CertValidator validator, Date validAt, Set<ServiceType> preferredServiceTypes) {
        ArrayList<ServiceInformation> result = new ArrayList<ServiceInformation>();
        if (serviceInformation != null) {
            List sortedServiceInformation = new ArrayList<ServiceInformation>(serviceInformation).stream().sorted(Comparator.comparing(CertificateData::getCertificate, (x, y) -> y.getNotAfter().compareTo(x.getNotAfter()))).collect(Collectors.toList());
            for (ServiceInformation ic : sortedServiceInformation) {
                X509Certificate certificate;
                Date validFrom = ic.getValidFrom();
                if (validAt != null && validFrom != null && validFrom.after(validAt) || !validator.isValid(certificate = ic.getCertificate())) continue;
                result.add(ic);
            }
            if (result.size() > 1) {
                this.filterForBestStiStatus(result, preferredServiceTypes);
            }
        }
        return result;
    }

    private void filterForBestStiStatus(List<ServiceInformation> services, Set<ServiceType> preferredServiceType) {
        ServiceInformation bestNationalService = null;
        ServiceInformation bestQualifiedService = null;
        for (ServiceInformation serviceInfo : services) {
            boolean isYounger;
            boolean isPreferred;
            ServiceStatus status = serviceInfo.getServiceStatus();
            ServiceType serviceTypeIdentifier = serviceInfo.getServiceTypeIdentifier();
            boolean bl = isPreferred = preferredServiceType.isEmpty() || serviceTypeIdentifier != null && preferredServiceType.contains(serviceTypeIdentifier);
            if (ServiceStatus.WITHDRAWN.equals((Object)status) || ServiceStatus.GRANTED.equals((Object)status)) {
                boolean bl2 = isYounger = bestQualifiedService == null || bestQualifiedService.getValidFrom().before(serviceInfo.getValidFrom());
                if (!isPreferred || !isYounger) continue;
                bestQualifiedService = serviceInfo;
                continue;
            }
            boolean bl3 = isYounger = bestNationalService == null || bestNationalService.getValidFrom().before(serviceInfo.getValidFrom());
            if (!isPreferred || !isYounger) continue;
            bestNationalService = serviceInfo;
        }
        if (bestQualifiedService != null && ServiceStatus.GRANTED.equals((Object)bestQualifiedService.getServiceStatus())) {
            services.clear();
            services.add(bestQualifiedService);
        } else if (bestQualifiedService != null && bestNationalService != null) {
            if (ServiceStatus.WITHDRAWN.equals((Object)bestQualifiedService.getServiceStatus()) && this.isRecognisedAtNationalLevel(bestNationalService.getServiceStatus())) {
                services.clear();
                services.add(bestNationalService);
            } else if (ServiceStatus.WITHDRAWN.equals((Object)bestQualifiedService.getServiceStatus()) && this.isDeprecatedAtNationalLevel(bestNationalService.getServiceStatus())) {
                services.clear();
                services.add(bestQualifiedService);
            }
        } else if (bestQualifiedService == null) {
            services.clear();
            if (bestNationalService != null) {
                services.add(bestNationalService);
            }
        } else {
            services.clear();
            services.add(bestQualifiedService);
        }
    }

    private boolean isRecognisedAtNationalLevel(ServiceStatus serviceStatus) {
        return ServiceStatus.RECOGNIZED_AT_NATIONAL_LEVEL.equals((Object)serviceStatus) || ServiceStatus.UNDER_SUPERVISION.equals((Object)serviceStatus) || ServiceStatus.SUPERVISION_IN_CESSATION.equals((Object)serviceStatus) || ServiceStatus.ACCREDITED.equals((Object)serviceStatus) || ServiceStatus.SET_BY_NATIONAL_LAW.equals((Object)serviceStatus);
    }

    private boolean isDeprecatedAtNationalLevel(ServiceStatus serviceStatus) {
        return ServiceStatus.DEPRECATED_AT_NATIONAL_LEVEL.equals((Object)serviceStatus) || ServiceStatus.SUPERVISION_CEASED.equals((Object)serviceStatus) || ServiceStatus.SUPERVISION_REVOKED.equals((Object)serviceStatus) || ServiceStatus.DEPRECATED_BY_NATIONAL_LAW.equals((Object)serviceStatus) || ServiceStatus.ACCREDITATION_CEASED.equals((Object)serviceStatus) || ServiceStatus.ACCREDITATION_REVOKED.equals((Object)serviceStatus);
    }

    private Set<ServiceType> obtainPreferredServiceTypes(X509CertificateBaseFacade<?> cert) {
        HashSet<ServiceType> prefTypes = new HashSet<ServiceType>();
        if (cert instanceof X509CertificateImpl && this.hasCertificatePurposeTimestamping(cert)) {
            prefTypes.addAll(Arrays.asList(ServiceType.QTST, ServiceType.TSA, ServiceType.TSS_AdESQCandQES, ServiceType.TSS_QC));
        }
        return prefTypes;
    }

    private boolean hasCertificatePurposeTimestamping(X509CertificateBaseFacade<?> cert) {
        List extendedKeyUsage = null;
        try {
            extendedKeyUsage = ((X509CertificateImpl)cert).getExtendedKeyUsage();
        }
        catch (CertificateParsingException e) {
            LOGGER.debug("Could not decode extended key usage of certificate with serialnumber {}", (Object)cert.getSerialNumber(), (Object)e);
        }
        return extendedKeyUsage != null && extendedKeyUsage.contains("1.3.6.1.5.5.7.3.8");
    }

    private TLCertStoreResponse getSigningCertificates(X500Principal issuer, CertValidator validator, Date validAt, Set<ServiceType> preferredServiceTypes) {
        String name = this.getIdentifier(issuer);
        List lic = (List)this.entries.get(name);
        List<ServiceInformation> lmtse = this.filterServiceInformation(lic, validator, validAt, preferredServiceTypes);
        return this.createResponse(lmtse);
    }

    private TLCertStoreResponse createResponse(List<ServiceInformation> lmtse) {
        TLCertStoreResponse resp = new TLCertStoreResponse(lmtse, InformationSource.CONFIGURATION);
        resp.setIssuedByTrustStore(true);
        ExtendedTLInformation tlInfo = new ExtendedTLInformation();
        tlInfo.setTslInfo(this.identifier);
        tlInfo.setTslExtensionInfo(this.extensionIdentifier);
        tlInfo.setReliabilityConcerns(this.reliabilityConcerns);
        tlInfo.setTslType(this.tlType);
        resp.setTlInformation(tlInfo);
        return resp;
    }

    protected void checkDistinctEntries(ManagedTL otherTL) throws DuplicateCertificateException {
        Map otherEntries = otherTL.entries;
        for (Map.Entry entry : this.entries.entrySet()) {
            String key = (String)entry.getKey();
            List otherList = (List)otherEntries.get(key);
            if (otherList == null || otherList.isEmpty()) continue;
            List thisList = (List)entry.getValue();
            this.checkDistinctEntries(thisList, otherList);
        }
    }

    private void checkDistinctEntries(List<ServiceInformation> a, List<ServiceInformation> b) throws DuplicateCertificateException {
        for (ServiceInformation aInformation : a) {
            X509Certificate aCert = aInformation.getCertificate();
            for (ServiceInformation bInformation : b) {
                X509Certificate bCert = bInformation.getCertificate();
                if (!bCert.equals(aCert)) continue;
                throw new DuplicateCertificateException(bCert);
            }
        }
    }

    protected void addReliabilityConcern(String concern) {
        if (this.reliabilityConcerns == null) {
            this.reliabilityConcerns = new ArrayList<String>();
        }
        this.reliabilityConcerns.add(concern);
    }

    public List<String> getReliabilityConcerns() {
        return this.reliabilityConcerns;
    }

    protected void setReliabilityConcerns(List<String> reliabilityConcerns) {
        this.reliabilityConcerns = reliabilityConcerns;
    }

    public TLType getTslType() {
        return this.tlType;
    }

    public void setTslType(TLType tlType) {
        this.tlType = tlType;
    }

    private static interface CertValidator {
        public boolean isValid(X509Certificate var1);
    }
}

