/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.simple.xml;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TrackingResourceResolver
extends ResourceResolverSpi {
    private boolean wholeDocumentSigned = false;
    private final XPathFactory xpathFactory = XPathFactory.newInstance();
    private final XPath xpath = this.xpathFactory.newXPath();

    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        Document doc = context.attr.getOwnerDocument();
        String uriToResolve = context.uriToResolve;
        if (uriToResolve == null || uriToResolve.isEmpty()) {
            this.wholeDocumentSigned = true;
            return new XMLSignatureInput((Node)doc.getDocumentElement());
        }
        XMLSignatureInput result = this.resolveByID(doc, uriToResolve.substring(1));
        if (result != null) {
            return result;
        }
        result = this.resolveByXPointer(doc, uriToResolve);
        if (result != null) {
            return result;
        }
        throw new ResourceResolverException("signature.Verification.MissingResources", new Object[]{uriToResolve}, uriToResolve, null);
    }

    private XMLSignatureInput resolveByXPointer(Document doc, String uriToResolve) throws ResourceResolverException {
        if (uriToResolve.equals("#xpointer(/)")) {
            this.wholeDocumentSigned = true;
            return new XMLSignatureInput((Node)doc.getDocumentElement());
        }
        if (uriToResolve.startsWith("#xpointer(id(") && uriToResolve.endsWith("))")) {
            String xpointerID = uriToResolve.substring(14, uriToResolve.length() - 3);
            return this.resolveByID(doc, xpointerID);
        }
        return null;
    }

    private XMLSignatureInput resolveByID(Document doc, String id) throws ResourceResolverException {
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate("//child::*[@Id='" + id + "']", doc.getDocumentElement(), XPathConstants.NODESET);
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            if (nodeList.getLength() > 1) {
                throw new ResourceResolverException("signature.Verification.MultipleIDs", new Object[]{id}, id, null);
            }
            Node item = nodeList.item(0);
            this.wholeDocumentSigned |= item == doc.getDocumentElement();
            return new XMLSignatureInput(item);
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        return true;
    }

    public boolean isWholeDocumentSigned() {
        return this.wholeDocumentSigned;
    }
}

