/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.simple.xml;

import de.governikus.csl.server.val.X509TrustedCertificateSelector;
import de.governikus.csl.simple.xml.EnvelopedXMLSignatureValidationResult;
import de.governikus.csl.simple.xml.TrackingResourceResolver;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.utils.CryptoUtil;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.security.auth.x500.X500Principal;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EnvelopedXMLSignatureValidator {
    static final String MSG_SIZE_READ_ERROR = "Error during cert retrieval from store.";
    static final String MSG_NULL_INPUT = "The provided input stream was null.";
    public static final String MSG_PARSE_ERROR = "The cvs response cannot be parsed.";
    private static final String CVS_RESPONSE = " [cvsResponse={}]";
    public static final String MSG_NOT_SIGNED = "The cvs response is not signed.";
    public static final String MSG_MULTI_SIG = "Found multiple signatures in cvs response.";
    public static final String MSG_EMPTY_STORE = "Empty store of trusted certificates configured.";
    public static final String MSG_MISSING_SIGNER = "Did not find a SignerCertificate.";
    public static final String MSG_MISSING_KEYINFO = "Did not find a KeyInfo.";
    private static final String MSG_X509DATA_FOUND = "Could find a X509Data element in the KeyInfo";
    private static final String MSG_SEARCH_FOR_TRUSTED_ISSUER = "Searching for trusted issuer certificate of signer [cert={}].";
    private static final String MSG_NO_TRUSTED_ISSUER_FOUND = "No trusted issuer certificate found for signer [cert={}].";
    private static final String MSG_SIGNATURE_RESULT = "The XML signature is {} [id={}, wholeDocSigned={}].";
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvelopedXMLSignatureValidator.class);
    private CertStore trustedIssuerCertStore;
    private static final X509CertSelector ALL_CERT_SELECTOR = new X509CertSelector();
    private boolean isEmptyCertStore = false;

    public boolean hasEmptyCertStore() {
        return this.isEmptyCertStore;
    }

    public EnvelopedXMLSignatureValidator(CertStore trustedIssuerCertStore) {
        this.trustedIssuerCertStore = trustedIssuerCertStore;
        try {
            this.isEmptyCertStore = trustedIssuerCertStore != null ? trustedIssuerCertStore.getCertificates(ALL_CERT_SELECTOR).isEmpty() : true;
        }
        catch (CertStoreException e) {
            LOGGER.error(MSG_SIZE_READ_ERROR, (Throwable)e);
        }
    }

    public EnvelopedXMLSignatureValidator(List<X509Certificate> trustedCertificates) {
        this(EnvelopedXMLSignatureValidator.createCertStore(trustedCertificates));
    }

    private String responseAsString(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((TransformerFactory)tf);
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (Exception e) {
            return ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
    }

    private IllegalArgumentException getIllegalArgExcp(String msg) {
        return new IllegalArgumentException(msg);
    }

    private void logResponse(String msg, Document cvsResp) {
        this.logResponse(() -> true, msg, cvsResp);
    }

    private void logResponse(Supplier<Boolean> condition, String msg, Document cvsResp) {
        if (condition.get().booleanValue() && LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg + CVS_RESPONSE, (Object)this.responseAsString(cvsResp));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EnvelopedXMLSignatureValidationResult validate(InputStream signedXML) {
        if (signedXML == null) {
            throw this.getIllegalArgExcp(MSG_NULL_INPUT);
        }
        Init.init();
        try (InputStream xmlStream = signedXML;){
            Document doc = CryptoUtil.createDocument((InputStream)xmlStream);
            if (doc == null) {
                LOGGER.error(MSG_PARSE_ERROR);
                EnvelopedXMLSignatureValidationResult envelopedXMLSignatureValidationResult = new EnvelopedXMLSignatureValidationResult(this.getIllegalArgExcp(MSG_PARSE_ERROR));
                return envelopedXMLSignatureValidationResult;
            }
            NodeList sigNode = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            EnvelopedXMLSignatureValidationResult checkErrResult = this.checkErrors(doc, sigNode);
            if (checkErrResult != null) {
                EnvelopedXMLSignatureValidationResult envelopedXMLSignatureValidationResult = checkErrResult;
                return envelopedXMLSignatureValidationResult;
            }
            TrackingResourceResolver resolver = new TrackingResourceResolver();
            XMLSignature signature = this.getXMLSignature(sigNode, resolver);
            KeyInfo ki = signature.getKeyInfo();
            if (ki != null) {
                this.logResponse(() -> ki.containsX509Data(), MSG_X509DATA_FOUND, doc);
                X509Certificate signerCert = ki.getX509Certificate();
                if (signerCert == null) {
                    this.logResponse(MSG_MISSING_SIGNER, doc);
                    EnvelopedXMLSignatureValidationResult envelopedXMLSignatureValidationResult = new EnvelopedXMLSignatureValidationResult(this.getIllegalArgExcp(MSG_MISSING_SIGNER));
                    return envelopedXMLSignatureValidationResult;
                }
                X500Principal subjectX500Principal = signerCert.getSubjectX500Principal();
                String signerCommonName = CryptoUtil.getCommonName((X500Principal)subjectX500Principal);
                if (this.isEmptyCertStore) {
                    LOGGER.warn("Empty store of trusted certificates configured. [cvsResponse={}]", (Object)this.responseAsString(doc));
                    EnvelopedXMLSignatureValidationResult envelopedXMLSignatureValidationResult = new EnvelopedXMLSignatureValidationResult(this.getIllegalArgExcp(MSG_EMPTY_STORE), signerCommonName);
                    return envelopedXMLSignatureValidationResult;
                }
                EnvelopedXMLSignatureValidationResult envelopedXMLSignatureValidationResult = this.checkSigner(doc, signature, resolver, signerCert, signerCommonName);
                return envelopedXMLSignatureValidationResult;
            }
            this.logResponse(MSG_MISSING_KEYINFO, doc);
            EnvelopedXMLSignatureValidationResult envelopedXMLSignatureValidationResult = new EnvelopedXMLSignatureValidationResult(this.getIllegalArgExcp(MSG_MISSING_KEYINFO));
            return envelopedXMLSignatureValidationResult;
        }
        catch (Exception ex) {
            return new EnvelopedXMLSignatureValidationResult(ExceptionUtils.getRootCause((Throwable)ex));
        }
    }

    EnvelopedXMLSignatureValidationResult checkErrors(Document doc, NodeList nl) {
        if (nl == null || nl.getLength() == 0) {
            LOGGER.warn("The cvs response is not signed. [cvsResponse={}]", (Object)this.responseAsString(doc));
            return new EnvelopedXMLSignatureValidationResult(this.getIllegalArgExcp(MSG_NOT_SIGNED));
        }
        if (nl.getLength() > 1) {
            LOGGER.error("Found multiple signatures in cvs response. [cvsResponse={}]", (Object)this.responseAsString(doc));
            return new EnvelopedXMLSignatureValidationResult(this.getIllegalArgExcp(MSG_MULTI_SIG));
        }
        return null;
    }

    private XMLSignature getXMLSignature(NodeList sigNode, TrackingResourceResolver resolver) throws XMLSignatureException, XMLSecurityException {
        JCEMapper.setProviderId((String)"BC");
        Element sigElement = (Element)sigNode.item(0);
        XMLSignature signature = new XMLSignature(sigElement, null);
        signature.addResourceResolver((ResourceResolverSpi)resolver);
        return signature;
    }

    private EnvelopedXMLSignatureValidationResult checkSigner(Document doc, XMLSignature signature, TrackingResourceResolver resolver, X509Certificate signerCert, String signerCommonName) throws XMLSignatureException, CertStoreException {
        LOGGER.debug(MSG_SEARCH_FOR_TRUSTED_ISSUER, (Object)signerCert.getSubjectX500Principal());
        boolean verification = signature.checkSignatureValue(signerCert);
        boolean wholeDocSigned = resolver.isWholeDocumentSigned();
        LOGGER.debug(MSG_SIGNATURE_RESULT, new Object[]{verification ? "valid" : "invalid", signature.getElement().getAttribute("Id"), wholeDocSigned});
        Collection<? extends Certificate> trustedIssuercertificates = this.trustedIssuerCertStore.getCertificates(new X509TrustedCertificateSelector(signerCert));
        if (trustedIssuercertificates.isEmpty()) {
            LOGGER.debug(MSG_NO_TRUSTED_ISSUER_FOUND, (Object)signerCert.getSubjectX500Principal());
            return new EnvelopedXMLSignatureValidationResult(false, wholeDocSigned, signerCommonName);
        }
        return new EnvelopedXMLSignatureValidationResult(verification, wholeDocSigned, true, signerCommonName);
    }

    private static CertStore createCertStore(List<X509Certificate> allowedCertificates) {
        if (allowedCertificates == null || allowedCertificates.isEmpty()) {
            return null;
        }
        CollectionCertStoreParameters certStoreParameters = new CollectionCertStoreParameters(allowedCertificates);
        try {
            return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, CryptoProviderUtil.PROVIDER);
        }
        catch (Exception e) {
            try {
                return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, "BC");
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

