/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.server.val;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509TrustedCertificateSelector
implements CertSelector {
    public static final Logger LOG = LoggerFactory.getLogger(X509TrustedCertificateSelector.class);
    private final X509Certificate searchCertificate;
    public static final X509Certificate ALL = new X509Certificate(){

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return false;
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return null;
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }

        @Override
        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public PublicKey getPublicKey() {
            return null;
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return null;
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return null;
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return null;
        }

        @Override
        public Principal getSubjectDN() {
            return null;
        }

        @Override
        public byte[] getSignature() {
            return null;
        }

        @Override
        public byte[] getSigAlgParams() {
            return null;
        }

        @Override
        public String getSigAlgOID() {
            return null;
        }

        @Override
        public String getSigAlgName() {
            return null;
        }

        @Override
        public BigInteger getSerialNumber() {
            return null;
        }

        @Override
        public Date getNotBefore() {
            return null;
        }

        @Override
        public Date getNotAfter() {
            return null;
        }

        @Override
        public boolean[] getKeyUsage() {
            return null;
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return null;
        }

        @Override
        public Principal getIssuerDN() {
            return null;
        }

        @Override
        public int getBasicConstraints() {
            return 0;
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        }
    };

    public X509TrustedCertificateSelector(X509Certificate searchCertificate) {
        this.searchCertificate = searchCertificate;
    }

    @Override
    public boolean match(Certificate cert) {
        if (this.searchCertificate == ALL) {
            return true;
        }
        if (!(cert instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509issuerCandidate = (X509Certificate)cert;
        if (this.searchCertificate.getSubjectX500Principal().equals(x509issuerCandidate.getSubjectX500Principal()) && this.searchCertificate.getIssuerX500Principal().equals(x509issuerCandidate.getIssuerX500Principal()) && this.searchCertificate.getSerialNumber().equals(x509issuerCandidate.getSerialNumber())) {
            return true;
        }
        boolean result = x509issuerCandidate.getSubjectX500Principal().equals(this.searchCertificate.getIssuerX500Principal());
        if (result) {
            try {
                this.searchCertificate.verify(x509issuerCandidate.getPublicKey());
            }
            catch (Exception e) {
                LOG.debug("Certificate was not signed by issuer certificate with matching principal.", (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    @Override
    public Object clone() {
        return new X509TrustedCertificateSelector(this.searchCertificate);
    }
}

