/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.server.val;

import de.governikus.csl.server.val.X509TrustedCertificateSelector;
import de.governikus.csl.uom.jce.CertUtil;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleXMLSignatureValidator {
    public static final CertStore TRUST_ALL_CERT_STORE;
    public static final NamespaceContext XMLDSIG_CONTEXT;
    public static final String XPATH_DS_SIGNATURE = "//ds:Signature";
    private static final Logger LOG;
    private CertStore trustedCerts;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document createDocument(InputStream stream) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            try (InputStream is = stream;){
                Document document = db.parse(is);
                return document;
            }
        }
        catch (Exception e) {
            LOG.error("Can't create document", (Throwable)e);
            return null;
        }
    }

    public SimpleXMLSignatureValidator() {
        this(null);
    }

    public SimpleXMLSignatureValidator(CertStore trustedCerts) {
        this.trustedCerts = trustedCerts;
    }

    public boolean checkSignature(URL urlSignedXML) {
        return SimpleXMLSignatureValidator.checkSignature(urlSignedXML, this.getTrustedCertStore());
    }

    public static NodeList getNodes(Document d, String xpathString, NamespaceContext nc) {
        return SimpleXMLSignatureValidator.getNodes(d.getDocumentElement(), xpathString, nc);
    }

    public static NodeList getNodes(Node n, String xpathString, NamespaceContext nc) {
        try {
            XPathFactory xf = XPathFactory.newInstance();
            XPath xp = xf.newXPath();
            if (nc != null) {
                xp.setNamespaceContext(nc);
            }
            NodeList sigNodes = (NodeList)xp.compile(xpathString).evaluate(n, XPathConstants.NODESET);
            return sigNodes;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkSignature(URL urlSignedXML, CertStore trustedIssuerCertStore) {
        if (urlSignedXML == null) {
            return false;
        }
        try (InputStream xmlStream = urlSignedXML.openStream();){
            boolean bl = SimpleXMLSignatureValidator.checkSignature(xmlStream, urlSignedXML.toString(), trustedIssuerCertStore);
            return bl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean checkSignature(InputStream signedXML, String baseURI, CertStore trustedIssuerCertStore) {
        return SimpleXMLSignatureValidator.checkSignature(signedXML, baseURI, trustedIssuerCertStore, null);
    }

    public static boolean checkSignature(InputStream signedXML, String baseURI, List<X509Certificate> certs) {
        return SimpleXMLSignatureValidator.checkSignature(signedXML, baseURI, SimpleXMLSignatureValidator.createCertStore(certs), null);
    }

    public static boolean checkSignature(InputStream signedXML, List<X509Certificate> certs) {
        return SimpleXMLSignatureValidator.checkSignature(signedXML, null, SimpleXMLSignatureValidator.createCertStore(certs), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkSignature(InputStream signedXML, String baseURI, CertStore trustedIssuerCertStore, ResourceResolverSpi resolver) {
        if (trustedIssuerCertStore == null) {
            return false;
        }
        if (signedXML == null) {
            return false;
        }
        try (InputStream xmlStream = signedXML;){
            Document doc = SimpleXMLSignatureValidator.createDocument(xmlStream);
            if (doc == null) {
                boolean bl = false;
                return bl;
            }
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            xpath.setNamespaceContext(XMLDSIG_CONTEXT);
            NodeList nl = (NodeList)xpath.evaluate(XPATH_DS_SIGNATURE, doc, XPathConstants.NODESET);
            if (nl == null || nl.getLength() != 1) {
                boolean bl = false;
                return bl;
            }
            Element sigElement = (Element)nl.item(0);
            JCEMapper.setProviderId((String)"BC");
            XMLSignature signature = new XMLSignature(sigElement, baseURI);
            signature.addResourceResolver((ResourceResolverSpi)(resolver != null ? resolver : new DefaultResolver(doc)));
            KeyInfo ki = signature.getKeyInfo();
            if (ki != null) {
                X509Certificate signerCert;
                if (ki.containsX509Data()) {
                    LOG.debug("Could find a X509Data element in the KeyInfo");
                }
                if ((signerCert = signature.getKeyInfo().getX509Certificate()) == null) {
                    LOG.debug("Did not find a SignerCertificate");
                    boolean bl = false;
                    return bl;
                }
                LOG.debug("searching for trusted issuer certificate of signer cert: " + signerCert.getIssuerX500Principal());
                if (trustedIssuerCertStore == TRUST_ALL_CERT_STORE) {
                    LOG.debug("all issuers are trusted - only checking signature integrity");
                } else {
                    Collection<? extends Certificate> trustedIssuercertificates = trustedIssuerCertStore.getCertificates(new X509TrustedCertificateSelector(signerCert));
                    if (trustedIssuercertificates.isEmpty()) {
                        LOG.debug("no trusted signer/issuer certificate found: " + signerCert.getIssuerX500Principal());
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean verification = signature.checkSignatureValue(signerCert);
                LOG.debug("The XML signature (ID: " + sigElement.getAttribute("Id") + ") in file " + baseURI + " is " + (verification ? "valid (good)" : "invalid !!!!! (bad)"));
                boolean bl = verification;
                return bl;
            }
            LOG.debug("Did not find a KeyInfo");
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static CertStore createCertStore(List<X509Certificate> allowedCertificates) {
        if (allowedCertificates == null || allowedCertificates.isEmpty()) {
            return null;
        }
        CollectionCertStoreParameters certStoreParameters = new CollectionCertStoreParameters(allowedCertificates);
        try {
            return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, CryptoProviderUtil.PROVIDER);
        }
        catch (Exception e) {
            try {
                return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParameters, "BC");
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public CertStore getTrustedCertStore() {
        return this.trustedCerts;
    }

    public void setTrustedCertStore(CertStore trustedCerts) {
        this.trustedCerts = trustedCerts;
    }

    static {
        Init.init();
        CertStore tmp = null;
        try {
            tmp = CertUtil.createCertStore(Collections.emptyList(), (String[])new String[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TRUST_ALL_CERT_STORE = tmp;
        XMLDSIG_CONTEXT = new NamespaceContext(){

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return Arrays.asList("ds").iterator();
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return "ds";
            }

            @Override
            public String getNamespaceURI(String prefix) {
                return "http://www.w3.org/2000/09/xmldsig#";
            }
        };
        LOG = LoggerFactory.getLogger(SimpleXMLSignatureValidator.class);
    }

    private static class DefaultResolver
    extends ResourceResolverSpi {
        private Document doc;

        public DefaultResolver(Document doc) {
            this.doc = doc;
        }

        public boolean engineCanResolveURI(ResourceResolverContext context) {
            LOG.debug(context.uriToResolve);
            String uriToResolve = context.uriToResolve;
            NodeList nl = null;
            if (uriToResolve == null || uriToResolve.isEmpty()) {
                return true;
            }
            nl = SimpleXMLSignatureValidator.getNodes(this.doc, "//child::*[@Id='" + uriToResolve.substring(1) + "']", null);
            return nl != null && nl.getLength() == 1;
        }

        public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
            String uriToResolve = context.uriToResolve;
            NodeList nl = null;
            if (uriToResolve == null || uriToResolve.isEmpty()) {
                return new XMLSignatureInput((Node)this.doc.getDocumentElement());
            }
            nl = SimpleXMLSignatureValidator.getNodes(this.doc, "//child::*[@Id='" + uriToResolve.substring(1) + "']", null);
            if (nl == null) {
                return null;
            }
            return new XMLSignatureInput(nl.item(0));
        }
    }
}

