/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.result;

import de.governikus.csl.result.SignatureValidationResultVisitor;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.TimestampValidationResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationResultVisitor
extends SignatureValidationResultVisitor {
    private Stack<Boolean> isPartOfTimestamp = new Stack();
    private Set<ByteBuffer> certificates;
    private Set<ByteBuffer> ocspResponses;
    private Set<ByteBuffer> crls;
    private Set<ByteBuffer> timestampCertificates;
    private Set<ByteBuffer> timestampOcspResponses;
    private Set<ByteBuffer> timestampCrls;
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationResultVisitor.class);
    private boolean collectDataFromSignature = false;

    public ValidationResultVisitor() {
    }

    public ValidationResultVisitor(boolean collectDataFromSignature) {
        this();
        this.collectDataFromSignature = collectDataFromSignature;
    }

    @Override
    public void startVisitingSignatureTimestampValidationResult(TimestampValidationResult tsr) {
        this.isPartOfTimestamp.push(true);
    }

    @Override
    public void startVisitingSignedDataTimestampValidationResult(TimestampValidationResult tsr) {
        this.isPartOfTimestamp.push(true);
    }

    @Override
    public void stopVisitingSignatureTimestampValidationResult(TimestampValidationResult tsr) {
        this.isPartOfTimestamp.pop();
    }

    @Override
    public void stopVisitingSignedDataTimestampValidationResult(TimestampValidationResult tsr) {
        this.isPartOfTimestamp.pop();
    }

    @Override
    public void startVisitingCertificateValidationResult(PublicKeyCertificateValidationResult s) {
        if (s.getInformationSource() == InformationSource.SIGNATURE && !this.collectDataFromSignature) {
            return;
        }
        try {
            byte[] data = s.getCert().getEncoded();
            if (this.isInTimestampMode()) {
                if (this.timestampCertificates == null) {
                    this.timestampCertificates = new HashSet<ByteBuffer>();
                }
                this.timestampCertificates.add(ByteBuffer.wrap(data));
            } else {
                if (this.certificates == null) {
                    this.certificates = new HashSet<ByteBuffer>();
                }
                this.certificates.add(ByteBuffer.wrap(data));
            }
        }
        catch (CertificateEncodingException e) {
            LOGGER.warn("Can't encode certificate.", (Throwable)e);
        }
    }

    @Override
    public void startVisitingRevocationValueValidationResult(RevocationValueValidationResult revocationValueValidationResult) {
        if (revocationValueValidationResult.getInformationSource() == InformationSource.SIGNATURE && !this.collectDataFromSignature) {
            return;
        }
        X509CRL crl = revocationValueValidationResult.getCrl();
        OCSPResp ocsp = revocationValueValidationResult.getOcsp();
        byte[] crlData = null;
        byte[] ocspData = null;
        if (crl != null) {
            try {
                crlData = crl.getEncoded();
            }
            catch (CRLException e) {
                LOGGER.warn("Can't serialize CRL", (Throwable)e);
            }
        }
        if (ocsp != null) {
            try {
                ocspData = ocsp.getEncoded();
            }
            catch (IOException e) {
                LOGGER.warn("Can't serialize OCSP", (Throwable)e);
            }
        }
        if (this.isInTimestampMode()) {
            if (crlData != null) {
                if (this.timestampCrls == null) {
                    this.timestampCrls = new HashSet<ByteBuffer>();
                }
                this.timestampCrls.add(ByteBuffer.wrap(crlData));
            }
            if (ocspData != null) {
                if (this.timestampOcspResponses == null) {
                    this.timestampOcspResponses = new HashSet<ByteBuffer>();
                }
                this.timestampOcspResponses.add(ByteBuffer.wrap(ocspData));
            }
        } else {
            if (crlData != null) {
                if (this.crls == null) {
                    this.crls = new HashSet<ByteBuffer>();
                }
                this.crls.add(ByteBuffer.wrap(crlData));
            }
            if (ocspData != null) {
                if (this.ocspResponses == null) {
                    this.ocspResponses = new HashSet<ByteBuffer>();
                }
                this.ocspResponses.add(ByteBuffer.wrap(ocspData));
            }
        }
    }

    private boolean isInTimestampMode() {
        return !this.isPartOfTimestamp.isEmpty() && this.isPartOfTimestamp.peek() != false;
    }

    public Set<ByteBuffer> getCertificates() {
        return this.certificates;
    }

    public Set<ByteBuffer> getOcspResponses() {
        return this.ocspResponses;
    }

    public Set<ByteBuffer> getCrls() {
        return this.crls;
    }

    public Set<ByteBuffer> getTimestampCertificates() {
        return this.timestampCertificates;
    }

    public Set<ByteBuffer> getTimestampOcspResponses() {
        return this.timestampOcspResponses;
    }

    public Set<ByteBuffer> getTimestampCrls() {
        return this.timestampCrls;
    }
}

