/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.result;

import de.governikus.csl.result.ObjectValidationResultVisitor;
import de.governikus.csl.result.SignatureValidationResultWalker;
import de.governikus.csl.uom.validate.ContainerValidationResult;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import java.util.List;

public class UntypedObjectValidationResultWalker
extends SignatureValidationResultWalker {
    public void walkResult(ObjectValidationResult result, ObjectValidationResultVisitor<ObjectValidationResult> visitor) {
        visitor.startVisitingObjectValidationResult(result);
        this.doWalk(result, visitor);
        visitor.stopVisitingObjectValidationResult(result);
    }

    public void walkIncludedResult(ObjectValidationResult result, ObjectValidationResultVisitor<ObjectValidationResult> visitor) {
        visitor.startVisitingIncludedFileValidationResults(result);
        this.doWalk(result, visitor);
        visitor.stopVisitingIncludedFileValidationResults(result);
    }

    private void doWalk(ObjectValidationResult result, ObjectValidationResultVisitor<ObjectValidationResult> visitor) {
        List includedFileValidationResults;
        ContainerValidationResult cvr;
        List resultsForContainedObjects;
        List signatureValidationResults = result.getSignatureValidationResults();
        if (signatureValidationResults != null) {
            for (SignatureValidationResult sig : signatureValidationResults) {
                this.walkResult(sig, visitor);
            }
        }
        if (result instanceof ContainerValidationResult && (resultsForContainedObjects = (cvr = (ContainerValidationResult)result).getResultsForContainedObjects()) != null) {
            for (ObjectValidationResult containedResult : resultsForContainedObjects) {
                this.walkResult(containedResult, visitor);
            }
        }
        if ((includedFileValidationResults = result.getIncludedFileValidationResults()) != null && !includedFileValidationResults.isEmpty()) {
            for (ObjectValidationResult containedResult : includedFileValidationResults) {
                this.walkIncludedResult(containedResult, visitor);
            }
        }
    }
}

