/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.result;

import de.governikus.csl.result.SignatureValidationResultVisitor;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.TimestampValidationResult;
import de.governikus.csl.validate.svp.AdESSignatureValidationResult;
import de.governikus.csl.validate.svp.ArchiveTimestampValidationResult;
import java.util.List;

public class SignatureValidationResultWalker {
    private boolean walkSignatureTimestamps = true;
    private boolean walkSignedDataTimestamps = true;
    private boolean walkCertificates = true;
    private boolean walkRevocationValues = true;
    private boolean walkCounterSignatures = true;
    private boolean handleCertAndRevocationResultsAsSignature = false;

    public void walkResult(SignatureValidationResult result, SignatureValidationResultVisitor visitor) {
        if (result instanceof PublicKeyCertificateValidationResult && !this.isHandleCertAndRevocationResultsAsSignature()) {
            this.walkCertificateValidationResult((PublicKeyCertificateValidationResult)result, visitor);
        } else if (result instanceof RevocationValueValidationResult && !this.isHandleCertAndRevocationResultsAsSignature()) {
            this.walkRevocationValueValidationResult((RevocationValueValidationResult)result, visitor);
        } else {
            visitor.startVisitingSignatureValidationResult(result);
            this.walkSignatureValidationResult(result, visitor);
            visitor.stopVisitingSignatureValidationResult(result);
        }
    }

    protected void walkSignatureValidationResult(SignatureValidationResult result, SignatureValidationResultVisitor visitor) {
        PublicKeyCertificateValidationResult s = result.getSigningCertificateValidationResult();
        if (s != null && this.isWalkCertificates()) {
            this.walkCertificateValidationResult(s, visitor);
        }
        List signatureTimestamps = result.getSignatureTimestampResults();
        if (this.isWalkSignatureTimestamps() && signatureTimestamps != null && !signatureTimestamps.isEmpty()) {
            for (TimestampValidationResult tsr : signatureTimestamps) {
                visitor.startVisitingSignatureTimestampValidationResult(tsr);
                this.walkSignatureValidationResult((SignatureValidationResult)tsr, visitor);
                visitor.stopVisitingSignatureTimestampValidationResult(tsr);
            }
        }
        List signedDataTimestamps = result.getSignedDataTimestampResults();
        if (this.isWalkSignedDataTimestamps() && signedDataTimestamps != null && !signedDataTimestamps.isEmpty()) {
            for (TimestampValidationResult tsr : signedDataTimestamps) {
                visitor.startVisitingSignedDataTimestampValidationResult(tsr);
                this.walkSignatureValidationResult((SignatureValidationResult)tsr, visitor);
                visitor.stopVisitingSignedDataTimestampValidationResult(tsr);
            }
        }
        if (result instanceof AdESSignatureValidationResult) {
            List counterSignatureValidationResults;
            AdESSignatureValidationResult ar = (AdESSignatureValidationResult)result;
            List archiveTimestampValidationResults = ar.getArchiveTimestampValidationResults();
            if (archiveTimestampValidationResults != null) {
                for (ArchiveTimestampValidationResult archiveTimestampValidationResult : archiveTimestampValidationResults) {
                    visitor.startVisitingArchiveTimestampValidationResult(archiveTimestampValidationResult);
                    this.walkSignatureValidationResult((SignatureValidationResult)archiveTimestampValidationResult, visitor);
                    visitor.stopVisitingArchiveTimestampValidationResult(archiveTimestampValidationResult);
                }
            }
            if ((counterSignatureValidationResults = ar.getCounterSignatureValidationResults()) != null && this.isWalkCounterSignatures()) {
                for (SignatureValidationResult counterSignatureValidationResult : counterSignatureValidationResults) {
                    visitor.startVisitingSignatureValidationResult(counterSignatureValidationResult);
                    this.walkSignatureValidationResult(counterSignatureValidationResult, visitor);
                    visitor.stopVisitingSignatureValidationResult(counterSignatureValidationResult);
                }
            }
        }
    }

    private void walkCertificateValidationResult(PublicKeyCertificateValidationResult certificateValidationResult, SignatureValidationResultVisitor visitor) {
        visitor.startVisitingCertificateValidationResult(certificateValidationResult);
        RevocationValueValidationResult revocationValueValidationResult = certificateValidationResult.getRevocationValueValidationResult();
        if (revocationValueValidationResult != null && this.isWalkRevocationValues()) {
            this.walkRevocationValueValidationResult(revocationValueValidationResult, visitor);
        }
        this.walkSignatureValidationResult((SignatureValidationResult)certificateValidationResult, visitor);
        visitor.stopVisitingCertificateValidationResult(certificateValidationResult);
    }

    private void walkRevocationValueValidationResult(RevocationValueValidationResult revocationValueValidationResult, SignatureValidationResultVisitor visitor) {
        visitor.startVisitingRevocationValueValidationResult(revocationValueValidationResult);
        this.walkSignatureValidationResult((SignatureValidationResult)revocationValueValidationResult, visitor);
        visitor.stopVisitingRevocationValueValidationResult(revocationValueValidationResult);
    }

    public boolean isWalkSignatureTimestamps() {
        return this.walkSignatureTimestamps;
    }

    public void setWalkSignatureTimestamps(boolean walkSignatureTimestamps) {
        this.walkSignatureTimestamps = walkSignatureTimestamps;
    }

    public boolean isWalkSignedDataTimestamps() {
        return this.walkSignedDataTimestamps;
    }

    public void setWalkSignedDataTimestamps(boolean walkSignedDataTimestamps) {
        this.walkSignedDataTimestamps = walkSignedDataTimestamps;
    }

    public boolean isWalkCertificates() {
        return this.walkCertificates;
    }

    public void setWalkCertificates(boolean walkCertificates) {
        this.walkCertificates = walkCertificates;
    }

    public boolean isWalkRevocationValues() {
        return this.walkRevocationValues;
    }

    public void setWalkRevocationValues(boolean walkRevocationValues) {
        this.walkRevocationValues = walkRevocationValues;
    }

    public boolean isWalkCounterSignatures() {
        return this.walkCounterSignatures;
    }

    public void setWalkCounterSignatures(boolean walkCounterSignatures) {
        this.walkCounterSignatures = walkCounterSignatures;
    }

    public boolean isHandleCertAndRevocationResultsAsSignature() {
        return this.handleCertAndRevocationResultsAsSignature;
    }

    public void setHandleCertAndRevocationResultsAsSignature(boolean handleCertAndRevocationResultsAsSignature) {
        this.handleCertAndRevocationResultsAsSignature = handleCertAndRevocationResultsAsSignature;
    }
}

