/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.result;

import de.governikus.csl.result.ObjectValidationResultVisitor;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import java.util.ArrayList;
import java.util.List;

public class SignatureCollectingResultVisitor
extends ObjectValidationResultVisitor<ObjectValidationResult> {
    private List<SignatureValidationResult> signatureValidationResults = new ArrayList<SignatureValidationResult>();
    private int depth = 0;

    @Override
    public void startVisitingSignatureValidationResult(SignatureValidationResult signatureValidationResult) {
        this.signatureValidationResults.add(signatureValidationResult);
        ++this.depth;
    }

    @Override
    public void stopVisitingSignatureValidationResult(SignatureValidationResult signatureValidationResult) {
        --this.depth;
    }

    @Override
    public void startVisitingCertificateValidationResult(PublicKeyCertificateValidationResult s) {
        if (this.depth == 0) {
            this.signatureValidationResults.add((SignatureValidationResult)s);
        }
        ++this.depth;
    }

    @Override
    public void stopVisitingCertificateValidationResult(PublicKeyCertificateValidationResult s) {
        --this.depth;
    }

    @Override
    public void startVisitingRevocationValueValidationResult(RevocationValueValidationResult revocationValueValidationResult) {
        if (this.depth == 0) {
            this.signatureValidationResults.add((SignatureValidationResult)revocationValueValidationResult);
        }
        ++this.depth;
    }

    @Override
    public void stopVisitingRevocationValueValidationResult(RevocationValueValidationResult revocationValueValidationResult) {
        --this.depth;
    }

    public List<SignatureValidationResult> getSignatureValidationResults() {
        return this.signatureValidationResults;
    }
}

