/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.result;

import de.governikus.csl.uom.Principal;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class LDAPEntry
implements Principal {
    private String commonName;
    private String organisation;
    private String country;

    public LDAPEntry() {
    }

    public LDAPEntry(X500Principal principal) {
        String dn = principal.getName();
        try {
            LdapName ldapDN = new LdapName(dn);
            for (Rdn rdn : ldapDN.getRdns()) {
                String type;
                switch (type = rdn.getType().toLowerCase()) {
                    case "cn": {
                        this.commonName = rdn.getValue().toString();
                        break;
                    }
                    case "c": {
                        this.country = rdn.getValue().toString();
                        break;
                    }
                    case "o": {
                        this.organisation = rdn.getValue().toString();
                        break;
                    }
                }
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }
}

