/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.request;

import de.governikus.csl.request.ObjectToValidateVisitor;
import de.governikus.csl.uom.validate.commons.ContainerObjectToValidate;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.Timestamp;
import java.util.List;

public class ObjectToValidateWalker {
    public void walkObject(ObjectToValidate<?> object, ObjectToValidateVisitor visitor) {
        ContainerObjectToValidate container;
        List<ObjectToValidate<?>> containedObjectsToValidate;
        visitor.startVisitingObjectToValidate(object);
        List<?> signatures = object.getSignatures();
        if (signatures != null) {
            for (Signature sig : signatures) {
                this.walkSignature(sig, visitor);
            }
        }
        if (object instanceof ContainerObjectToValidate && (containedObjectsToValidate = (container = (ContainerObjectToValidate)object).getContainedObjectsToValidate()) != null) {
            for (ObjectToValidate<?> containedObject : containedObjectsToValidate) {
                this.walkObject(containedObject, visitor);
            }
        }
        visitor.stopVisitingObjectToValidate(object);
    }

    private void walkSignature(Signature sig, ObjectToValidateVisitor visitor) {
        List<? extends Timestamp> signedDataTimestamps;
        visitor.startVisitingSignature(sig);
        List<? extends Timestamp> signatureTimestamps = sig.getSignatureTimestamps();
        if (signatureTimestamps != null) {
            for (Timestamp timestamp : signatureTimestamps) {
                visitor.startVisitingSignatureTimestamp(timestamp);
                visitor.stopVisitingSignatureTimestamp(timestamp);
            }
        }
        if ((signedDataTimestamps = sig.getSignedDataTimestamps()) != null) {
            for (Timestamp timestamp : signedDataTimestamps) {
                visitor.startVisitingDataTimestamp(timestamp);
                visitor.stopVisitingDataTimestamp(timestamp);
            }
        }
        visitor.stopVisitingSignature(sig);
    }
}

