/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.functional;

import de.governikus.csl.result.SignatureCollectingResultVisitor;
import de.governikus.csl.result.UntypedObjectValidationResultWalker;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ResultInterpreter;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.validate.svp.ERSValidationResult;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class AllSignaturesCheck
implements ResultInterpreter {
    public String getDescriptionMsgCode() {
        return "functional.test.allSignatures.description";
    }

    public ValidationResult getInterpretedResult(ObjectValidationResult validationResult) {
        UntypedObjectValidationResultWalker walker = new UntypedObjectValidationResultWalker();
        SignatureCollectingResultVisitor visitor = new SignatureCollectingResultVisitor();
        walker.walkResult(validationResult, visitor);
        List<SignatureValidationResult> signatureValidationResults = visitor.getSignatureValidationResults();
        if (signatureValidationResults != null) {
            signatureValidationResults.removeIf(ERSValidationResult.class::isInstance);
        }
        if (signatureValidationResults == null || signatureValidationResults.isEmpty()) {
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, null, (String[])new String[]{"functional.test.allSignatures.notSigned"});
        }
        MajorTotalResult current = MajorTotalResult.TOTAL_PASSED;
        current = this.cumulateSignatureValidationResults(current, signatureValidationResults);
        String msgCode = this.selectMsgCode(current);
        return SVPFactory.create((MajorTotalResult)current, null, (String[])new String[]{msgCode});
    }

    private MajorTotalResult cumulateResults(MajorTotalResult current, SignatureValidationResult svr) {
        CumulatedValidationResult overallResult = svr.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR);
        MajorTotalResult major = overallResult.getMajor();
        return MajorTotalResult.max((MajorTotalResult)current, (MajorTotalResult)major);
    }

    private MajorTotalResult cumulateSignatureValidationResults(MajorTotalResult current, List<? extends SignatureValidationResult> csValidationResultList) {
        if (csValidationResultList != null) {
            for (SignatureValidationResult signatureValidationResult : csValidationResultList) {
                current = this.cumulateResults(current, signatureValidationResult);
            }
        }
        return current;
    }

    private String selectMsgCode(MajorTotalResult result) {
        switch (result) {
            case INDETERMINATE: {
                return "functional.test.allSignatures.indeterminate";
            }
            case TOTAL_FAILED: {
                return "functional.test.allSignatures.invalid";
            }
            case TOTAL_PASSED: {
                return "functional.test.allSignatures.valid";
            }
        }
        return null;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("i18n.functional_validations", locale);
    }

    public boolean useResourceBundleForMajorResult() {
        return false;
    }
}

