/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.core.impl;

import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class X509CRLAdapter
extends XmlAdapter<byte[], X509CRL> {
    public X509CRL unmarshal(byte[] v) throws Exception {
        CertificateFactory certificateFactoryInstance = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
        try (ByteArrayInputStream bais = new ByteArrayInputStream(v);){
            X509CRL x509CRL = (X509CRL)certificateFactoryInstance.generateCRL(bais);
            return x509CRL;
        }
    }

    public byte[] marshal(X509CRL v) throws Exception {
        return v.getEncoded();
    }
}

