/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.core.impl;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.CRLReason;
import de.governikus.csl.uom.validate.commons.RevocationStatus;
import de.governikus.csl.validate.svp.TypedDate;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class RevocationValue {
    private List<ValidationMessageCode> validationMessageCodes;
    private int responseStatus;
    private CRLReason reason;
    private OCSPResp ocspValue;
    private X509CRL crlValue;
    private Date revocationTime;
    private RevocationStatus status;
    private Date thisUpdate;
    private Date nextUpdate;
    private Date creationDate;
    private Date archiveCutoffDate;
    private InformationSource source;
    private X509CertificateBaseFacade<?> certificateToCheck;
    private long requestDuration;
    private String url;
    private List<TypedDate> poes;

    public RevocationValue() {
    }

    public RevocationValue(RevocationValue other) {
        this.url = other.url;
        this.requestDuration = other.requestDuration;
        this.certificateToCheck = other.certificateToCheck;
        this.source = other.source;
        this.archiveCutoffDate = other.archiveCutoffDate;
        this.creationDate = other.creationDate;
        this.responseStatus = other.responseStatus;
        this.reason = other.reason;
        this.ocspValue = other.ocspValue;
        this.crlValue = other.crlValue;
        this.revocationTime = other.revocationTime;
        this.status = other.status;
        this.thisUpdate = other.thisUpdate;
        this.nextUpdate = other.nextUpdate;
        this.validationMessageCodes = other.validationMessageCodes;
    }

    public CRLReason getReason() {
        return this.reason;
    }

    public void setReason(CRLReason reason) {
        this.reason = reason;
    }

    public OCSPResp getOcspValue() {
        return this.ocspValue;
    }

    public void setOcspValue(OCSPResp ocspValue) {
        this.ocspValue = ocspValue;
    }

    public X509CRL getCrlValue() {
        return this.crlValue;
    }

    public void setCrlValue(X509CRL crlValue) {
        this.crlValue = crlValue;
    }

    public void setRevocationDate(Date revocationTime) {
        this.revocationTime = revocationTime;
    }

    public Date getRevocationDate() {
        return this.revocationTime;
    }

    public void setStatus(RevocationStatus revoked) {
        this.status = revoked;
    }

    public RevocationStatus getStatus() {
        return this.status;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(Date nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public InformationSource getSource() {
        return this.source;
    }

    public void setSource(InformationSource source) {
        this.source = source;
    }

    public Date getArchiveCutoffDate() {
        return this.archiveCutoffDate;
    }

    public void setArchiveCutoffDate(Date archiveCutoffData) {
        this.archiveCutoffDate = archiveCutoffData;
    }

    @XmlTransient
    public void setCertificateToCheck(X509CertificateBaseFacade<?> userCert) {
        this.certificateToCheck = userCert;
    }

    public X509CertificateBaseFacade<?> getCertificateToCheck() {
        return this.certificateToCheck;
    }

    public long getRequestDuration() {
        return this.requestDuration;
    }

    public void setRequestDuration(long requestDuration) {
        this.requestDuration = requestDuration;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
    }

    public List<TypedDate> getPoes() {
        return this.poes;
    }

    public void setPoes(List<TypedDate> poes) {
        this.poes = poes;
    }

    public List<ValidationMessageCode> getValidationMessageCodes() {
        return this.validationMessageCodes;
    }

    public void setValidationMessageCodes(List<ValidationMessageCode> validationMessageCodes) {
        this.validationMessageCodes = validationMessageCodes;
    }

    public boolean hasValidationMessages() {
        return !this.hasNoValidationMessages() && !this.validationMessageCodes.isEmpty();
    }

    public boolean hasNoValidationMessages() {
        return this.validationMessageCodes == null;
    }

    public void addValidationMessage(String messageCode, Object ... params) {
        if (this.validationMessageCodes == null) {
            this.validationMessageCodes = new ArrayList<ValidationMessageCode>();
        }
        this.validationMessageCodes.add(SVPFactory.createMessageCode((String)messageCode, (Object[])params));
    }
}

