/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.core.impl;

import de.bos_bremen.ci.asn1.x509.PolicyInformation;
import de.bos_bremen.ci.asn1.x509.QCStatement;
import de.governikus.csl.result.LDAPEntry;
import de.governikus.csl.uom.Principal;
import de.governikus.csl.uom.validate.KeyUsage;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.CertificateUtil;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;

public class CertificateWrapper
extends CertificateUtil
implements de.governikus.csl.uom.validate.commons.Certificate {
    private X509Certificate cert;
    private boolean[] usage;
    private List<QCStatement> qcStatements;
    private List<PolicyInformation> policyInformations;

    public CertificateWrapper(X509Certificate cert) {
        this.cert = cert;
        this.usage = cert.getKeyUsage();
    }

    public byte[] getSignedData() {
        return null;
    }

    public Signature getSignature() {
        return null;
    }

    public Date getValidFrom() {
        return this.cert.getNotBefore();
    }

    public Date getValidUntil() {
        return this.cert.getNotAfter();
    }

    public Certificate getCertificate() {
        return this.cert;
    }

    public String toString() {
        return this.cert.toString();
    }

    public BigInteger getSerial() {
        return this.cert.getSerialNumber();
    }

    public boolean isUsableFor(KeyUsage usage) {
        int index;
        boolean result = false;
        if (this.usage != null && this.usage.length > (index = usage.getIndex())) {
            result = this.usage[index];
        }
        return result;
    }

    public List<QCStatement> getQCStatements() {
        if (this.qcStatements == null) {
            this.qcStatements = this.getQCStatements(this.cert);
        }
        return this.qcStatements;
    }

    public List<PolicyInformation> getCertificatePolicies() {
        if (this.policyInformations == null) {
            this.policyInformations = this.getCertificatePolicies(this.cert);
        }
        return this.policyInformations;
    }

    private boolean hasQCStatement(String oid) {
        List<QCStatement> qcs = this.getQCStatements();
        if (qcs != null) {
            for (QCStatement qc : qcs) {
                if (!qc.getOID().getOID().equals(oid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPolicyIdentifier(String oid) {
        List<PolicyInformation> lpi = this.getCertificatePolicies();
        if (lpi != null) {
            for (PolicyInformation pi : lpi) {
                if (!pi.getCertPolicyId().getOID().equals(oid)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasQCComplianceStatement() {
        return this.hasQCStatement("0.4.0.1862.1.1");
    }

    public boolean hasQCSSCDStatement() {
        return this.hasQCStatement("0.4.0.1862.1.4");
    }

    public boolean hasQCPSSCDPolicy() {
        return this.hasPolicyIdentifier("0.4.0.1456.1.1");
    }

    public boolean hasQCPPolicy() {
        return this.hasPolicyIdentifier("0.4.0.1456.1.2");
    }

    public Principal getIssuer() {
        return new LDAPEntry(this.cert.getIssuerX500Principal());
    }
}

