/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.core.impl;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.SignatureClass;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.uom.validate.commons.WritableSignature;
import de.governikus.csl.validate.svp.TypedDate;
import java.security.cert.CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class BaseSignature
implements WritableSignature {
    protected TypedDate signingDate;
    protected X509CertificateImpl signingCertificate;
    protected boolean isSigningCertificateTrustedAnchor = false;
    protected Set<AttributeCertificate> attributeCertificates;
    protected SignatureAlgorithm signatureAlgorithm;
    protected byte[] signatureValue;
    protected Document signedContent;
    protected List<? extends SignedContentPart> signedContentParts;
    private List<? extends Timestamp> signatureTimestamps;
    private List<? extends Timestamp> signedDataTimestamps;
    private String ID;
    private Set<SignatureValidationDataAttachment<X509Certificate>> attachedCertificates;
    private List<SignatureValidationDataAttachment<OCSPResp>> attachedOCSPValues;
    private List<SignatureValidationDataAttachment<CRL>> attachedCRLs;
    private SignedObjectType type = SignedObjectType.DATA;
    private ValidationResult parseError;

    @Override
    public TypedDate getSigningTime() {
        return this.signingDate;
    }

    @Override
    public X509CertificateImpl getSigningCertificate() {
        return this.signingCertificate;
    }

    @Override
    public boolean isSigningCertificateTrustedAnchor() {
        return this.isSigningCertificateTrustedAnchor;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    @Override
    public Document getSignedContent() {
        return this.signedContent;
    }

    @Override
    public List<? extends SignedContentPart> getSignedContentParts() {
        return this.signedContentParts;
    }

    @Override
    public void setSigningTime(TypedDate signingDate) {
        this.signingDate = signingDate;
    }

    @Override
    public void setSigningCertificate(X509CertificateImpl signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    @Override
    public void setSigningCertificateTrustedAnchor(boolean isTrustedAnchor) {
        this.isSigningCertificateTrustedAnchor = isTrustedAnchor;
    }

    @Override
    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public void setSignatureValue(byte[] signatureValue) {
        this.signatureValue = signatureValue;
    }

    @Override
    public void setSignedContent(Document signedContent) {
        this.signedContent = signedContent;
    }

    @Override
    public void setSignedContentParts(List<? extends SignedContentPart> signedContentParts) {
        this.signedContentParts = signedContentParts;
    }

    @Override
    public SignatureClass getSignatureClass() {
        if (this.isCollectionNotEmpty(this.signatureTimestamps)) {
            if (this.isCollectionNotEmpty(this.attachedOCSPValues) || this.isCollectionNotEmpty(this.attachedCRLs)) {
                return SignatureClass.SIG_LT;
            }
            return SignatureClass.SIG_T;
        }
        return SignatureClass.SIG_B;
    }

    protected boolean isCollectionNotEmpty(Collection<?> collections) {
        return collections != null && !collections.isEmpty();
    }

    @Override
    public void setSignatureTimestamps(List<? extends Timestamp> timestamps) {
        this.signatureTimestamps = timestamps;
    }

    @Override
    public List<? extends Timestamp> getSignatureTimestamps() {
        return this.signatureTimestamps;
    }

    @Override
    public List<? extends Timestamp> getSignedDataTimestamps() {
        return this.signedDataTimestamps;
    }

    @Override
    public void setSignedDataTimestamps(List<? extends Timestamp> signedDataTimestamps) {
        this.signedDataTimestamps = signedDataTimestamps;
    }

    @Override
    public String getID() {
        return this.ID;
    }

    @Override
    public void setID(String iD) {
        this.ID = iD;
    }

    @Override
    public void setSignatureClass(SignatureClass signatureClass) {
    }

    @Override
    public void setAttachedCertificates(Set<SignatureValidationDataAttachment<X509Certificate>> certs) {
        this.attachedCertificates = certs;
    }

    @Override
    public Set<SignatureValidationDataAttachment<X509Certificate>> getAttachedCertificates() {
        return this.attachedCertificates;
    }

    @Override
    public void setAttachedOCSPValues(List<SignatureValidationDataAttachment<OCSPResp>> ocspResponses) {
        this.attachedOCSPValues = ocspResponses;
    }

    @Override
    public List<SignatureValidationDataAttachment<OCSPResp>> getAttachedOCSPValues() {
        return this.attachedOCSPValues;
    }

    @Override
    public List<SignatureValidationDataAttachment<CRL>> getAttachedCRLs() {
        return this.attachedCRLs;
    }

    @Override
    public void setAttachedCRLs(List<SignatureValidationDataAttachment<CRL>> attachedCRLs) {
        this.attachedCRLs = attachedCRLs;
    }

    @Override
    public void setAttributeCertificates(Set<AttributeCertificate> attributeCertificates) {
        this.attributeCertificates = attributeCertificates;
    }

    @Override
    public Set<AttributeCertificate> getAttributeCertificates() {
        return this.attributeCertificates;
    }

    @Override
    public SignedObjectType getType() {
        return this.type;
    }

    @Override
    public void setType(SignedObjectType type) {
        this.type = type;
    }

    public void copyValues(WritableSignature sig) {
        this.ID = sig.getID();
        this.signatureAlgorithm = sig.getSignatureAlgorithm();
        this.signatureTimestamps = sig.getSignatureTimestamps();
        this.signatureValue = sig.getSignatureValue();
        this.signedContent = sig.getSignedContent();
        this.signedContentParts = sig.getSignedContentParts();
        this.signedDataTimestamps = sig.getSignedDataTimestamps();
        this.signingCertificate = sig.getSigningCertificate();
        this.attributeCertificates = sig.getAttributeCertificates();
        this.signingDate = sig.getSigningTime();
        this.attachedCertificates = sig.getAttachedCertificates();
        this.attachedOCSPValues = sig.getAttachedOCSPValues();
        this.attachedCRLs = sig.getAttachedCRLs();
        this.type = sig.getType();
        this.parseError = sig.getParseError();
    }

    @Override
    public ValidationResult getParseError() {
        return this.parseError;
    }

    @Override
    public void setParseError(ValidationResult parseErrors) {
        this.parseError = parseErrors;
    }
}

