/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.certStore;

import de.governikus.csl.certStore.AbstractCertStore;
import de.governikus.csl.certStore.CertStoreResponseImpl;
import de.governikus.csl.certStore.CertificateData;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.utils.ByteArrayKey;
import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCertStore
extends AbstractCertStore {
    private static Logger LOGGER = LoggerFactory.getLogger(ListCertStore.class);
    private InformationSource informationSource;
    private Collection<SignatureValidationDataAttachment<X509Certificate>> certs;
    private Map<ByteArrayKey, List<SignatureValidationDataAttachment<X509Certificate>>> values;

    public ListCertStore(Collection<SignatureValidationDataAttachment<X509Certificate>> certs, InformationSource source) {
        this.certs = certs;
        this.informationSource = source;
        this.values = new HashMap<ByteArrayKey, List<SignatureValidationDataAttachment<X509Certificate>>>();
        for (SignatureValidationDataAttachment<X509Certificate> cert : certs) {
            byte[] ski = this.getSubjectKeyIdentifier(cert.getValue());
            if (ski == null) continue;
            ByteArrayKey key = new ByteArrayKey(ski);
            List<SignatureValidationDataAttachment<X509Certificate>> list = this.values.get(key);
            if (list == null) {
                list = new ArrayList<SignatureValidationDataAttachment<X509Certificate>>();
                this.values.put(key, list);
            }
            list.add(cert);
        }
    }

    @Override
    public CertStoreResponseImpl getSigningCertificates(X509CertificateBaseFacade<?> cert, Date date) {
        ArrayList<CertificateData> result;
        block6: {
            result = new ArrayList<CertificateData>();
            if (this.certs == null) break block6;
            List<SignatureValidationDataAttachment<X509Certificate>> issuers = this.getIssuerByAuthorityKeyIdentifier((X509Extension)cert);
            if (issuers != null) {
                for (SignatureValidationDataAttachment<X509Certificate> issuer : issuers) {
                    result.add(new CertificateData(issuer));
                }
            } else {
                for (SignatureValidationDataAttachment<X509Certificate> possibleIssuer : this.certs) {
                    try {
                        X509Certificate value = possibleIssuer.getValue();
                        cert.verify(value.getPublicKey());
                        result.add(new CertificateData(possibleIssuer));
                    }
                    catch (IllegalArgumentException | GeneralSecurityException e) {
                        LOGGER.debug("Certificate does not match to entry in cert store");
                    }
                }
            }
        }
        return new CertStoreResponseImpl(result, this.informationSource);
    }

    public InformationSource getInformationSource() {
        return this.informationSource;
    }

    public void setInformationSource(InformationSource informationSource) {
        this.informationSource = informationSource;
    }

    @Override
    public CertStoreResponseImpl getSigningCertificates(X509CRL crl) {
        ArrayList<CertificateData> result;
        block6: {
            result = new ArrayList<CertificateData>();
            if (this.certs == null) break block6;
            List<SignatureValidationDataAttachment<X509Certificate>> issuers = this.getIssuerByAuthorityKeyIdentifier(crl);
            if (issuers != null) {
                for (SignatureValidationDataAttachment<X509Certificate> issuer : issuers) {
                    result.add(new CertificateData(issuer));
                }
            } else {
                for (SignatureValidationDataAttachment<X509Certificate> possibleIssuer : this.certs) {
                    try {
                        X509Certificate value = possibleIssuer.getValue();
                        crl.verify(value.getPublicKey());
                        result.add(new CertificateData(possibleIssuer));
                    }
                    catch (IllegalArgumentException | GeneralSecurityException e) {
                        LOGGER.debug("CRL does not match to entry in cert store");
                    }
                }
            }
        }
        return new CertStoreResponseImpl(result, this.informationSource);
    }

    @Override
    public CertStoreResponseImpl getCertificates(X500Principal name) {
        ArrayList<CertificateData> result = new ArrayList<CertificateData>();
        if (this.certs != null) {
            for (SignatureValidationDataAttachment<X509Certificate> issuer : this.certs) {
                X509Certificate value = issuer.getValue();
                X500Principal subjectX500Principal = value.getSubjectX500Principal();
                if (!subjectX500Principal.equals(name)) continue;
                result.add(new CertificateData(issuer));
            }
        }
        return new CertStoreResponseImpl(result, this.informationSource);
    }

    private List<SignatureValidationDataAttachment<X509Certificate>> getIssuerByAuthorityKeyIdentifier(X509Extension x509) {
        byte[] authorityKeyIdentifierBytes = this.getAuthorityKeyIdentifierBytes(x509);
        if (authorityKeyIdentifierBytes == null) {
            return null;
        }
        return this.values.get(new ByteArrayKey(authorityKeyIdentifierBytes));
    }
}

