/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.certStore;

import de.governikus.csl.certStore.AuthorityInformationAccessCertStore;
import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.certStore.CertStoreCollection;
import de.governikus.csl.certStore.CertStoreResponse;
import de.governikus.csl.certStore.ListCertStore;
import de.governikus.csl.tsl.TLManager;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.InformationSource;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class FixedOrderCertStore
implements CertStoreCollection {
    private TLManager tlBasedCertStore;
    private AuthorityInformationAccessCertStore aiaCertStore;
    private ListCertStore signatureCertStore;
    private ListCertStore requestCertStore;
    private List<CertStore> stores;

    public FixedOrderCertStore(TLManager tlBasedCertStore) {
        this(tlBasedCertStore, null, null, null);
    }

    public FixedOrderCertStore(TLManager tlBasedCertStore, AuthorityInformationAccessCertStore aiaCertStore) {
        this(tlBasedCertStore, aiaCertStore, null, null);
    }

    private FixedOrderCertStore(TLManager tlBasedCertStore, AuthorityInformationAccessCertStore aiaCertStore, ListCertStore signatureCertStore, ListCertStore requestCertStore) {
        this.tlBasedCertStore = tlBasedCertStore;
        this.aiaCertStore = aiaCertStore;
        this.signatureCertStore = signatureCertStore;
        this.requestCertStore = requestCertStore;
        this.stores = new ArrayList<CertStore>();
        if (tlBasedCertStore != null) {
            this.stores.add(tlBasedCertStore);
        }
        if (signatureCertStore != null) {
            this.stores.add(signatureCertStore);
        }
        if (requestCertStore != null) {
            this.stores.add(requestCertStore);
        }
        if (aiaCertStore != null) {
            this.stores.add(aiaCertStore);
        }
    }

    public FixedOrderCertStore(ListCertStore listCertStore) {
        this(null, null, listCertStore, null);
    }

    @Override
    public FixedOrderCertStore fork(ListCertStore certStore) {
        InformationSource informationSource = certStore.getInformationSource();
        if (informationSource == InformationSource.REQUEST) {
            return new FixedOrderCertStore(this.tlBasedCertStore, this.aiaCertStore, this.signatureCertStore, certStore);
        }
        return new FixedOrderCertStore(this.tlBasedCertStore, this.aiaCertStore, certStore, this.requestCertStore);
    }

    @Override
    public CertStoreResponse getSigningCertificates(X509CertificateBaseFacade<?> cert, Date date) {
        for (CertStore store : this.stores) {
            CertStoreResponse res = store.getSigningCertificates(cert, date);
            if (res == null || res.getMatchingCertificates().isEmpty()) continue;
            return res;
        }
        return null;
    }

    @Override
    public CertStoreResponse getSigningCertificates(X509CRL crl) {
        for (CertStore store : this.stores) {
            CertStoreResponse res = store.getSigningCertificates(crl);
            if (res == null || res.getMatchingCertificates().isEmpty()) continue;
            return res;
        }
        return null;
    }

    @Override
    public CertStoreResponse getCertificates(X500Principal name) {
        for (CertStore store : this.stores) {
            CertStoreResponse res = store.getCertificates(name);
            if (res == null || res.getMatchingCertificates().isEmpty()) continue;
            return res;
        }
        return null;
    }
}

