/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.certStore;

import de.governikus.csl.certStore.AbstractCertStore;
import de.governikus.csl.certStore.CertStoreResponseImpl;
import de.governikus.csl.tsl.ServiceInformation;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.utils.ByteArrayKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendableCertStore
extends AbstractCertStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendableCertStore.class);
    private Map<ByteArrayKey, StoreEntry> values = new HashMap<ByteArrayKey, StoreEntry>();

    public void addCert(X509Certificate cert, InformationSource source) {
        byte[] ski = this.getSubjectKeyIdentifier(cert);
        if (ski == null) {
            return;
        }
        this.values.put(new ByteArrayKey(ski), new StoreEntry(cert, source));
    }

    private CertStoreResponseImpl createResponse(X509Certificate cert, InformationSource source) {
        ServiceInformation service = new ServiceInformation(cert);
        CertStoreResponseImpl resp = new CertStoreResponseImpl(Collections.singletonList(service), source);
        return resp;
    }

    @Override
    public CertStoreResponseImpl getSigningCertificates(X509CertificateBaseFacade<?> cert, Date date) {
        StoreEntry entry = this.getEntry((X509Extension)cert);
        if (entry == null) {
            return null;
        }
        try {
            cert.verify(entry.cert.getPublicKey());
            return this.createResponse(entry.cert, entry.source);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public CertStoreResponseImpl getSigningCertificates(X509CRL crl) {
        StoreEntry entry = this.getEntry(crl);
        if (entry == null) {
            return null;
        }
        try {
            crl.verify(entry.cert.getPublicKey());
            return this.createResponse(entry.cert, entry.source);
        }
        catch (Exception e) {
            return null;
        }
    }

    private StoreEntry getEntry(X509Extension x509) {
        byte[] authorityKeyIdentifierBytes = this.getAuthorityKeyIdentifierBytes(x509);
        if (authorityKeyIdentifierBytes == null) {
            return null;
        }
        return this.values.get(new ByteArrayKey(authorityKeyIdentifierBytes));
    }

    @Override
    public CertStoreResponseImpl getCertificates(X500Principal subject) {
        return null;
    }

    private class StoreEntry {
        private X509Certificate cert;
        private InformationSource source;

        StoreEntry(X509Certificate cert, InformationSource source) {
            this.cert = cert;
            this.source = source;
        }
    }
}

