/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.certStore;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.governikus.csl.certStore.CertStore;
import de.governikus.csl.certStore.CertStoreResponse;
import de.governikus.csl.certStore.CertStoreResponseImpl;
import de.governikus.csl.certStore.CertificateData;
import de.governikus.csl.certStore.ExtendableCertStore;
import de.governikus.csl.transport.Downloader;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.InformationSource;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.utils.LdapURL;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.naming.NamingException;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.x509.util.StreamParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityInformationAccessCertStore
extends Downloader
implements CertStore {
    private ExtendableCertStore cache = new ExtendableCertStore();
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorityInformationAccessCertStore.class);

    public AuthorityInformationAccessCertStore(HttpClient transportFactory, boolean sendNoCacheHeader, Map<String, String> ldapEnv) {
        super(transportFactory, sendNoCacheHeader, ldapEnv);
    }

    @Override
    public CertStoreResponseImpl getSigningCertificates(X509CertificateBaseFacade<?> cert, Date date) {
        CertStoreResponse signingCertificates = this.cache.getSigningCertificates((X509CertificateBaseFacade)cert, date);
        if (signingCertificates != null) {
            return signingCertificates;
        }
        return this.tryToObtainCertificateFromExtension((X509Extension)cert, x -> {
            try {
                cert.verify(x.getPublicKey());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                return false;
            }
            return true;
        });
    }

    @Override
    public CertStoreResponseImpl getSigningCertificates(X509CRL crl) {
        CertStoreResponseImpl signingCertificates = this.cache.getSigningCertificates(crl);
        if (signingCertificates != null) {
            return signingCertificates;
        }
        return this.tryToObtainCertificateFromExtension(crl, x -> {
            try {
                crl.verify(x.getPublicKey());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CRLException e) {
                return false;
            }
            return true;
        });
    }

    @Override
    public CertStoreResponseImpl getCertificates(X500Principal subject) {
        return null;
    }

    private CertStoreResponseImpl tryToObtainCertificateFromExtension(X509Extension extension, Predicate<X509Certificate> validator) {
        AccessDescription[] accessDescriptions;
        byte[] value = extension.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (value == null) {
            return null;
        }
        try {
            OCTETSTRING o = new OCTETSTRING(Run.create((Source)new BSource(value)));
            value = o.getOctets();
        }
        catch (ParseException e) {
            LOGGER.debug("CRLDistPoint is not encoded in octet string");
        }
        try {
            AuthorityInformationAccess ic = AuthorityInformationAccess.getInstance((Object)value);
            accessDescriptions = ic.getAccessDescriptions();
        }
        catch (IllegalArgumentException e) {
            LogHelper.logWarningOrPrintDebugException((String)"could not parse AuthorityInformationAccess object", (Logger)LOGGER, (Throwable)e);
            return null;
        }
        ArrayList<CertificateData> certs = null;
        if (accessDescriptions != null) {
            for (AccessDescription ad : accessDescriptions) {
                ASN1ObjectIdentifier accessMethod = ad.getAccessMethod();
                String oid = accessMethod.getId();
                GeneralName accessLocation = ad.getAccessLocation();
                String url = accessLocation.getName().toString();
                if (!oid.equals("1.3.6.1.5.5.7.48.2")) continue;
                byte[] data = null;
                try {
                    data = this.download(url);
                }
                catch (IOException | URISyntaxException | NamingException | StreamParsingException e) {
                    LOGGER.info("Exception occured during loading of crl from URL \"" + url + "\"");
                    LOGGER.debug("Exception:", e);
                }
                if (data == null) continue;
                try {
                    X509Certificate cert = CryptoProviderUtil.loadCert((byte[])data);
                    if (cert == null) continue;
                    this.cache.addCert(cert, InformationSource.ONLINE);
                    if (!validator.test(cert)) continue;
                    CertificateData info = new CertificateData(cert);
                    info.setCertificateURL(url);
                    if (certs == null) {
                        certs = new ArrayList<CertificateData>();
                    }
                    certs.add(info);
                }
                catch (IOException | NoSuchProviderException | CertificateException e) {
                    LogHelper.logException((String)"Can't parse downloaded certificate", (Logger)LOGGER, (Throwable)e);
                }
            }
        }
        if (certs != null) {
            CertStoreResponseImpl resp = new CertStoreResponseImpl(certs, InformationSource.ONLINE);
            return resp;
        }
        return null;
    }

    protected byte[] download(String url) throws IOException, URISyntaxException, StreamParsingException, NamingException {
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://")) {
            return this.getFromHTTP(url);
        }
        if (url.startsWith("ldap://")) {
            return this.getFromLDAP(url);
        }
        return null;
    }

    private byte[] getFromHTTP(String surl) throws IOException, URISyntaxException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loading certificate from URL: " + surl);
        }
        byte[] binaryFile = this.getBinaryFile(surl);
        return binaryFile;
    }

    private byte[] getFromLDAP(String ldapURL) throws StreamParsingException, NamingException, URISyntaxException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loading certificate from URL: " + ldapURL);
        }
        LdapURL url = new LdapURL(ldapURL);
        String host = url.getProviderURL();
        if (url.getHost() == null || host == null) {
            LOGGER.info("Invalid URL, skipping downloading of certificate");
            return null;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.provider.url", host);
        String[] attributes = new String[]{};
        List<String> attributes2 = url.getAttributes();
        if (attributes2 != null) {
            attributes = attributes2.toArray(attributes);
        }
        return this.sendLDAPRequestCRL(ldapURL, env, attributes);
    }
}

